<?php

namespace App\Http\Controllers;

use App\Models\Prodi;
use App\Exports\ProdiExport;
use Illuminate\Http\Request;
use Maatwebsite\Excel\Facades\Excel;
use Yajra\DataTables\Facades\DataTables;

class ProdiController extends Controller
{


    private $activeMenu = 'Home/Prodi';

    public function index(Request $request)
    {
        return view('pages.portal.master.prodi.index', [
            'breadcrumb' => [
                'Home' => '/',
                'Master' => '/',
                'Prodi' => '/'
            ],
            'activeMenu' => $this->activeMenu,

        ]);
    }

    public function list(Request $request)
    {

        $data = Prodi::query()->orderBy('jurusan', 'desc');

        return DataTables::of($data)
            ->addIndexColumn()
            ->addColumn('action', function (Prodi $prodi) {
                $actionBtn = '<a href="' . url("/prodi/edit/" . $prodi->id . "") . '" class="edit btn btn-primary btn-xs"><i class="fas fa-edit fa-sm" title="Edit"></i></a> <a href="javascript:void(0)" class="delete btn btn-danger btn-xs" title="Hapus" data-toggle="modal" data-target="#del' . $prodi->id . '"><i class="fas fa-trash fa-sm"></i></a>
                    <div class="modal fade" id="del' . $prodi->id . '">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-body text-left pb-0">
                                <h4>Hapus data</h4>
                                    <p>Data yang dihapus tidak bisa dipulihkan kembali</p>
                                </div>
                                <div class="modal-footer pt-0 border-0 justify-content-end">
                                    <form action="' . url("/prodi/delete/" . $prodi->id . "") . '" method="post">
                                        <input type="hidden" name="_method" value="DELETE">
                                        <input type="hidden" name="_token" value="' . csrf_token() . '">
                                        <a href="javascript:void(0)" class="btn mr-2" data-dismiss="modal">Kembali</a>
                                        <button class="btn btn-danger">Hapus</button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                    ';
                return $actionBtn;
            })
            ->rawColumns(['action'])
            ->make(true);
        // }

    }

    public function form(Request $request)
    {
        return view('pages.portal.master.prodi.form', [
            'breadcrumb' => [
                'Home' => '/',
                'Master' => '/',
                'Prodi' => '/user',
                'Form Tambah' => '/'
            ],
            'activeMenu' => $this->activeMenu,

        ]);
    }

    public function store(Request $request, Prodi $user)
    {
        $rules = [
            'kode' => 'required|min:3|unique:prodis',
            'prodi' => 'required|min:3',
            'jurusan' => 'required|min:3',
            'jenjang' => 'required'
        ];

        $dataValidated = $request->validate($rules);

        Prodi::create($dataValidated);

        return redirect('/prodi')->with('success', 'Data berhasil disimpan');
    }

    public function edit($id)
    {
        return view('pages.portal.master.prodi.form', [
            'breadcrumb' => [
                'Home' => '/',
                'Master' => '/',
                'Prodi' => '/prodi',
                'Form Edit' => '/'
            ],
            'activeMenu' => $this->activeMenu,
            'data' => Prodi::find($id),
            'id' => $id

        ]);
    }

    public function update(Request $request)
    {
        $prodi = Prodi::find($request->id);
        $rules = [
            'prodi' => 'required|min:3',
            'jurusan' => 'required|min:3',
            'jenjang' => 'required'
        ];

        if ($request->kode != $prodi->kode)
            $rules['kode'] = 'required|min:3|unique:prodis';

        $dataValidated = $request->validate($rules);

        Prodi::find($request->id)
            ->update($dataValidated);



        return redirect('/prodi')->with('success', 'Data berhasil disimpan');
    }

    public function destroy($id)
    {
        $prodi = Prodi::find($id);
        Prodi::destroy($id);
        return redirect('/prodi')->with('success', 'Data berhasil dihapus');
    }

    function export(Request $request)
    {
        return Excel::download(new ProdiExport, 'Data-Prodi-' . date('Ymd') . '.xlsx');
    }
}
