<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class PortalController extends Controller
{
    public function index()
    {
        if (auth()->user()->role == 'unit') {
            return view('pages.portal.clearancecard.index', [
                'breadcrumb' => [
                    'Home' => '/',
                    'Sidang' => '/',
                    'Clearance Card' => '/clearancecard'
                ],
                'activeMenu' => 'Home/Sidang/Clearancecard',
                'prodis' => $this->getProdiCombo(),
                'kelass' =>  $this->getKelasCombo(),
                'periodes' => $this->getPeriodeSidangCombo(),
                'bulans' => $this->getBulanSidangCombo(),
            ]);
        } else if (auth()->user()->role == 'dosen') {
            return redirect('/tor/potensi');
        } else {

            return view('pages.portal.index', [
                'breadcrumb' => [
                    'Home' => '/',
                    'Dasboard' => '/'
                ],
                'activeMenu' => 'Dashboard',
                'periodes' => $this->getPeriodeSidangCombo(),
                'bulans' => $this->getBulanSidangCombo(),
            ]);
        }
    }
}
