<?php

namespace App\Http\Controllers;

use App\Models\Periode;
use Illuminate\Http\Request;
use Yajra\DataTables\Facades\DataTables;

class PeriodeController extends Controller
{
    private $activeMenuTor = 'Home/Periode/Tor';
    private $activeMenuSidang = 'Home/Periode/Sidang';

    // Tor
    public function tor(Request $request)
    {


        return view('pages.portal.periode.tor.index', [
            'breadcrumb' => [
                'Home' => '/',
                'Periode' => '/',
                'Tor' => '/'
            ],
            'activeMenu' => $this->activeMenuTor,

        ]);
    }


    public function torList(Request $request)
    {

        $data = Periode::query()
            ->where('nama', 'tor')
            ->orderBy('periode', 'desc');

        return DataTables::of($data)
            ->addIndexColumn()
            ->addColumn('action', function (Periode $periode) {
                $actionBtn = '<a href="' . url("/periode/tor/edit/" . $periode->id . "") . '" class="edit btn btn-primary btn-xs"><i class="fas fa-edit fa-sm" title="Edit"></i></a>';
                return $actionBtn;
            })
            ->editColumn('aktif', function (Periode $periode) {
                $html = '';
                $html .= '
                    <input type="checkbox" class="check-active" name="active" id="' . $periode->id . '"
                        ' . ($periode->active == 1 ? "checked" : "") . '>
                ';

                return $html;
            })
            ->rawColumns(['action', 'aktif'])
            ->make(true);
    }

    public function torForm(Request $request)
    {
        return view('pages.portal.periode.tor.form', [
            'breadcrumb' => [
                'Home' => '/',
                'Periode' => '/',
                'Tor' => '/user',
                'Form Tambah' => '/'
            ],
            'activeMenu' => $this->activeMenuTor,
            'periodes' => $this->formPeriodeList()

        ]);
    }

    public function torStore(Request $request, Periode $periode)
    {
        $rules = [
            'periode' => 'required|min:3|unique:periodes,periode,NULL,id,nama,tor',
            'tgl_awal' => 'required|min:10|date_format:Y-m-d',
            'tgl_akhir' => 'required|min:10|date_format:Y-m-d'
        ];

        $dataValidated = $request->validate($rules);

        $dataValidated['nama'] = 'tor';

        Periode::create($dataValidated);

        return redirect('/periode/tor')->with('success', 'Data berhasil disimpan');
    }

    public function torEdit($id)
    {
        return view('pages.portal.periode.tor.form', [
            'breadcrumb' => [
                'Home' => '/',
                'Periode' => '/',
                'Tor' => '/periode/tor',
                'Form Edit' => '/'
            ],
            'activeMenu' => $this->activeMenuTor,
            'data' => Periode::find($id),
            'id' => $id

        ]);
    }

    public function torUpdate(Request $request)
    {
        $periode = Periode::find($request->id);
        $rules = [
            'tgl_awal' => 'required|min:10|date_format:Y-m-d',
            'tgl_akhir' => 'required|min:10|date_format:Y-m-d'
        ];

        if ($request->periode != $periode->periode)
            $rules['periode'] = 'required|min:3|unique:periodes,periode,NULL,id,nama,tor';

        $dataValidated = $request->validate($rules);

        Periode::find($request->id)
            ->update($dataValidated);

        return redirect('/periode/tor')->with('success', 'Data berhasil disimpan');
    }

    public function torUpdateActive(Request $request)
    {
        Periode::where('nama', 'tor')
            ->update([
                'active' => 0
            ]);

        Periode::find($request->id)
            ->update([
                'active' => $request->active
            ]);

        $this->setPeriodeSession();

        $data = [
            'msg' => 'Data berhasil disimpan'
        ];
        return response()->json($data);
    }

    // Sidang
    public function sidang(Request $request)
    {


        return view('pages.portal.periode.sidang.index', [
            'breadcrumb' => [
                'Home' => '/',
                'Periode' => '/',
                'Sidang' => '/'
            ],
            'activeMenu' => $this->activeMenuSidang,

        ]);
    }


    public function sidangList(Request $request)
    {

        $data = Periode::query()
            ->where('nama', 'sidang')
            ->orderBy('periode', 'desc');

        return DataTables::of($data)
            ->addIndexColumn()
            ->addColumn('action', function (Periode $periode) {
                $actionBtn = '<a href="' . url("/periode/sidang/edit/" . $periode->id . "") . '" class="edit btn btn-primary btn-xs"><i class="fas fa-edit fa-sm" title="Edit"></i></a>';
                return $actionBtn;
            })
            ->editColumn('aktif', function (Periode $periode) {
                $html = '';
                $html .= '
                    <input type="checkbox" class="check-active" name="active" id="' . $periode->id . '"
                        ' . ($periode->active == 1 ? "checked" : "") . '>
                ';

                return $html;
            })
            ->rawColumns(['action', 'aktif'])
            ->make(true);
    }

    public function sidangForm(Request $request)
    {
        return view('pages.portal.periode.sidang.form', [
            'breadcrumb' => [
                'Home' => '/',
                'Periode' => '/',
                'Sidang' => '/periode/sidang',
                'Form Tambah' => '/'
            ],
            'activeMenu' => $this->activeMenuSidang,
            'periodes' => $this->formPeriodeList()

        ]);
    }

    public function sidangStore(Request $request, Periode $periode)
    {
        $rules = [
            'periode' => 'required|min:3|unique:periodes,periode,NULL,id,nama,sidang,bulan,' . $request->bulan . '',
            'bulan' => 'required',
            'tgl_awal' => 'required|min:10|date_format:Y-m-d',
            'tgl_akhir' => 'required|min:10|date_format:Y-m-d'
        ];

        $dataValidated = $request->validate($rules);

        $dataValidated['nama'] = 'sidang';

        Periode::create($dataValidated);

        return redirect('/periode/sidang')->with('success', 'Data berhasil disimpan');
    }

    public function sidangEdit($id)
    {
        return view('pages.portal.periode.sidang.form', [
            'breadcrumb' => [
                'Home' => '/',
                'Periode' => '/',
                'Sidang' => '/periode/sidang',
                'Form Edit' => '/'
            ],
            'activeMenu' => $this->activeMenuSidang,
            'data' => Periode::find($id),
            'id' => $id

        ]);
    }

    public function sidangUpdate(Request $request)
    {
        $periode = Periode::find($request->id);
        $rules = [
            'bulan' => 'required',
            'tgl_awal' => 'required|min:10|date_format:Y-m-d',
            'tgl_akhir' => 'required|min:10|date_format:Y-m-d'
        ];

        if ($request->periode != $periode->periode)
            $rules['periode'] = 'required|min:3|unique:periodes,periode,NULL,id,nama,sidang,bulan,' . $request->bulan . '';

        $dataValidated = $request->validate($rules);

        Periode::find($request->id)
            ->update($dataValidated);

        return redirect('/periode/sidang')->with('success', 'Data berhasil disimpan');
    }

    public function sidangUpdateActive(Request $request)
    {
        Periode::where('nama', 'sidang')
            ->update([
                'active' => 0
            ]);

        Periode::find($request->id)
            ->update([
                'active' => $request->active
            ]);

        $this->setPeriodeSession();

        $data = [
            'msg' => 'Data berhasil disimpan'
        ];
        return response()->json($data);
    }
}
