<?php

namespace App\Http\Controllers;

use App\Models\Pejabat;
use Illuminate\Http\Request;
use App\Exports\PejabatExport;
use Maatwebsite\Excel\Facades\Excel;
use Yajra\DataTables\Facades\DataTables;

class PejabatController extends Controller
{

    private $activeMenu = 'Home/Pejabat';

    public function index(Request $request)
    {
        return view('pages.portal.master.pejabat.index', [
            'breadcrumb' => [
                'Home' => '/',
                'Master' => '/',
                'Pejabat' => '/'
            ],
            'activeMenu' => $this->activeMenu,

        ]);
    }

    public function list(Request $request)
    {

        $data = Pejabat::query()->orderBy('updated_at', 'desc');

        return DataTables::of($data)
            ->addIndexColumn()
            ->addColumn('action', function (Pejabat $pejabat) {
                $actionBtn = '<a href="' . url("/pejabat/edit/" . $pejabat->id . "") . '" class="edit btn btn-primary btn-xs"><i class="fas fa-edit fa-sm" title="Edit"></i></a> <a href="javascript:void(0)" class="delete btn btn-danger btn-xs" title="Hapus" data-toggle="modal" data-target="#del' . $pejabat->id . '"><i class="fas fa-trash fa-sm"></i></a>
                    <div class="modal fade" id="del' . $pejabat->id . '">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-body text-left pb-0">
                                <h4>Hapus data</h4>
                                    <p>Data yang dihapus tidak bisa dipulihkan kembali</p>
                                </div>
                                <div class="modal-footer pt-0 border-0 justify-content-end">
                                    <form action="' . url("/pejabat/delete/" . $pejabat->id . "") . '" method="post">
                                        <input type="hidden" name="_method" value="DELETE">
                                        <input type="hidden" name="_token" value="' . csrf_token() . '">
                                        <a href="javascript:void(0)" class="btn mr-2" data-dismiss="modal">Kembali</a>
                                        <button class="btn btn-danger">Hapus</button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                    ';
                return $actionBtn;
            })
            ->rawColumns(['action'])
            ->make(true);
        // }

    }

    public function form(Request $request)
    {
        return view('pages.portal.master.pejabat.form', [
            'breadcrumb' => [
                'Home' => '/',
                'Master' => '/',
                'Pejabat' => '/user',
                'Form Tambah' => '/'
            ],
            'activeMenu' => $this->activeMenu,

        ]);
    }

    public function store(Request $request, Pejabat $user)
    {
        $rules = [
            'kode' => 'required|min:3',
            'jabatan' => 'required|min:3',
            'nama' => 'required|min:3',
            'nidn' => 'required|unique:pejabats|regex:"^[0-9 ]+$"',
            'bagian' => 'required|min:3',
        ];

        $dataValidated = $request->validate($rules);

        Pejabat::create($dataValidated);

        return redirect('/pejabat')->with('success', 'Data berhasil disimpan');
    }

    public function edit($id)
    {
        return view('pages.portal.master.pejabat.form', [
            'breadcrumb' => [
                'Home' => '/',
                'Master' => '/',
                'Pejabat' => '/pejabat',
                'Form Edit' => '/'
            ],
            'activeMenu' => $this->activeMenu,
            'data' => Pejabat::find($id),
            'id' => $id

        ]);
    }

    public function update(Request $request)
    {
        $pejabat = Pejabat::find($request->id);
        $rules = [
            'kode' => 'required|min:3',
            'jabatan' => 'required|min:3',
            'nama' => 'required|min:3',
            'nidn' => 'required|regex:"^[0-9 ]+$"',
            'bagian' => 'required|min:3',
        ];

        $dataValidated = $request->validate($rules);

        Pejabat::find($request->id)
            ->update($dataValidated);



        return redirect('/pejabat')->with('success', 'Data berhasil disimpan');
    }

    public function destroy($id)
    {
        $pejabat = Pejabat::find($id);
        Pejabat::destroy($id);
        return redirect('/pejabat')->with('success', 'Data berhasil dihapus');
    }

    function export(Request $request)
    {
        return Excel::download(new PejabatExport, 'Data-Pejabat-' . date('Ymd') . '.xlsx');
    }
}
