<?php

namespace App\Http\Controllers;

use App\Models\Kategori;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Yajra\DataTables\Facades\DataTables;

class KategoriController extends Controller
{
    private $activeMenu = 'Home/Kategori';

    public function index(Request $request)
    {
        return view('pages.portal.kategori.index', [
            'breadcrumb' => [
                'Home' => '/',
                'Kategori' => '/'
            ],
            'activeMenu' => $this->activeMenu,
            'verifikators' => $this->getVerifikatorCombo(),
        ]);
    }

    public function get(Request $request)
    {
        if ($request->ajax()) {
            $data = Kategori::find($request->id);

            return response()->json($data);
        }
    }

    public function list(Request $request)
    {
        if ($request->ajax()) {
            $data = Kategori::query()
                ->leftJoin('users as u', 'u.id', 'kategoris.verifikator')
                ->select('kategoris.*', 'u.name', 'u.role')
                ->where('periode', session('periode_sidang'))
                ->where('bulan', session('bulan_sidang'))
                ->orderBy('id', 'asc');

            return DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
        }
    }

    public function store(Request $request)
    {

        $periode = session('periode_sidang');
        $bulan = session('bulan_sidang');
        $jenis = $request->jenis;
        $namaFix = $request->namaFix;
        $nama = $request->nama;
        $deskripsi =  $request->deskripsi;
        $uploadOption = $request->uploadOption;
        $tipe = $request->tipe;
        $size = $request->size;
        $verifikator = $request->verifikator;
        $path = 'file/template';
        $files =  $request->file('file');

        if ($uploadOption == '') {
            $uploadOption = '';
            $tipe = '';
            $size = 0;
        }

        // If edit
        if (isset($request->id)) {
            $ktgr = Kategori::find($request->id);

            Storage::delete('public/' . $ktgr->template);
        }

        if (!$request->hasFile('file')) {
            $file = '';
        } else {
            $filename = $periode . '_' . $bulan . '_' . $jenis . '_' . $nama;
            $ext = $files->getClientOriginalExtension();
            $file = $filename . '.' . $ext;
            $file = $files->storeAs($path, $file, 'public');
        }

        if (isset($request->id)) {
            // Update
            Kategori::find($request->id)->update([
                'nama' => $nama,
                'deskripsi' => $deskripsi,
                'upload' => $uploadOption,
                'template' => $file,
                'tipe' => $tipe,
                'size' => $size,
                'verifikator' => $verifikator,
            ]);
        } else {
            // Create
            Kategori::create([
                'periode' => $periode,
                'bulan' => $bulan,
                'jenis' => $jenis,
                'nama' => $nama,
                'dbase' => $namaFix,
                'deskripsi' => $deskripsi,
                'upload' => $uploadOption,
                'template' => $file,
                'tipe' => $tipe,
                'size' => $size,
                'verifikator' => $verifikator,
            ]);
        }

        return back()->with('success', 'Data berhasil disimpan');
    }

    public function destroy($id)
    {
        $ktgr = Kategori::find($id);

        Storage::delete('public/' . $ktgr->template);

        Kategori::destroy($id);

        return back()->with('success', 'Data berhasil dihapus');
    }
}
