<?php

namespace App\Http\Controllers;

use Carbon\Carbon;
use App\Models\Form;
use App\Models\Formdetail;
use App\Models\Formprodi;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Yajra\DataTables\Facades\DataTables;

class FormController extends Controller
{
    private $activeMenu = 'Home/Form/Buatform';
    private $activeMenuProdi = 'Home/Form/Formprodi';

    public function index(Request $request)
    {
        return view('pages.portal.form.form.index', [
            'breadcrumb' => [
                'Home' => '/',
                'Form Sidang' => '/'
            ],
            'activeMenu' => $this->activeMenu,

        ]);
    }

    public function list(Request $request)
    {

        if ($request->ajax()) {
            $data = Form::query();

            return DataTables::of($data)
                ->addIndexColumn()
                ->editColumn('created_at', function (Form $form) {
                    return Carbon::parse($form->created_at)->translatedFormat('d M Y');
                })
                ->editColumn('updated_at', function (Form $form) {
                    return Carbon::parse($form->updated_at)->translatedFormat('d M Y');
                })
                ->addColumn('action', function (Form $form) {
                    $actionBtn = '
                <a href="' . url("/form/formdetail/" . $form->id . "") . '" class="detail btn btn-primary btn-xs"><i class="fas fa-eye fa-sm" title="Detail"></i></a> 
                <a href="javascript:void(0)" class="edit btn btn-primary btn-xs" data-id="' . $form->id . '" data-nama="' . $form->nama . '"><i class="fas fa-edit fa-sm" title="Edit"></i></a> 
                <a href="javascript:void(0)" class="delete btn btn-danger btn-xs" title="Hapus" data-toggle="modal" data-target="#del' . $form->id . '"><i class="fas fa-trash fa-sm"></i></a>
                    <div class="modal fade" id="del' . $form->id . '">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-body text-left pb-0">
                                <h4>Hapus data</h4>
                                    <p>Data yang dihapus tidak bisa dipulihkan kembali</p>
                                </div>
                                <div class="modal-footer pt-0 border-0 justify-content-end">
                                    <form action="' . url("/form/delete/" . $form->id . "") . '" method="post">
                                        <input type="hidden" name="_method" value="DELETE">
                                        <input type="hidden" name="_token" value="' . csrf_token() . '">
                                        <a href="javascript:void(0)" class="btn mr-2" data-dismiss="modal">Kembali</a>
                                        <button class="btn btn-danger">Hapus</button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                    ';
                    return $actionBtn;
                })
                ->rawColumns(['created_at', 'updated_at', 'action'])
                ->make(true);
        }
    }

    public function destroy($id)
    {
        Form::destroy($id);
        Formdetail::where('form_id', $id)->delete();
        return back()->with('success', 'Data berhasil dihapus');
    }

    public function listdetail(Request $request)
    {

        if ($request->ajax()) {
            $datas = Formdetail::where('form_id', $request->form_id)
                ->where('jenis', 'judul')
                ->orderBy('nourut', 'asc')
                ->get();
            $datax = [];
            foreach ($datas as $data) {
                $subs = Formdetail::where('parent_id', $data->nourut)
                    ->where('form_id', $request->form_id)
                    ->orderBy('id', 'asc')
                    ->get();
                $datax[] = $data;
                foreach ($subs as $sub) {
                    $datax[] = $sub;
                }
            }

            // return response()->json($datax);;
            return DataTables::of($datax)
                ->addIndexColumn()
                ->editColumn('deskripsi', function (Formdetail $form) {
                    $html = '';
                    $html = '<p class="text-bold py-0 my-0">' . $form->deskripsi . '</p>';
                    if ($form->parent_id > 0) {
                        $html = '<p class="pl-3 py-0 my-0">' . $form->deskripsi . '</p>';
                    }
                    return $html;
                })
                ->addColumn('action', function (Formdetail $form) {
                    $actionBtn = '
                <a href="javascript:void(0)" class="edit btn btn-primary btn-xs" data-id="' . $form->id . '" data-nourut="' . $form->nourut . '" data-deskripsi="' . $form->deskripsi . '" data-bobot="' . $form->bobot . '" data-parent="' . $form->parent_id . '" data-jenis="' . $form->jenis . '"><i class="fas fa-edit fa-sm" title="Edit"></i></a> 
                <a href="javascript:void(0)" class="delete btn btn-danger btn-xs" title="Hapus" data-toggle="modal" data-target="#del' . $form->id . '"><i class="fas fa-trash fa-sm"></i></a>
                    <div class="modal fade" id="del' . $form->id . '">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-body text-left pb-0">
                                <h4>Hapus data</h4>
                                    <p>Data yang dihapus tidak bisa dipulihkan kembali</p>
                                </div>
                                <div class="modal-footer pt-0 border-0 justify-content-end">
                                    <form action="' . url("/form/formdetail/delete/" . $form->id . "") . '" method="post">
                                        <input type="hidden" name="_method" value="DELETE">
                                        <input type="hidden" name="_token" value="' . csrf_token() . '">
                                        <a href="javascript:void(0)" class="btn mr-2" data-dismiss="modal">Kembali</a>
                                        <button class="btn btn-danger">Hapus</button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                    ';
                    return $actionBtn;
                })
                ->rawColumns(['deskripsi', 'action'])
                ->make(true);
        }
    }

    public function store(Request $request)
    {
        $rules = [
            'nama' => 'required|regex:"^[a-zA-Z0-9 ]+$"|unique:forms',
        ];

        $dataValidated = $request->validate($rules);

        if ($request->id) {
            Form::find($request->id)->update($dataValidated);
        } else {
            Form::create($dataValidated);
        }

        return redirect('/form')->with('success', 'Data berhasil disimpan');
    }

    public function getNoUrut($id)
    {
        return Formdetail::where('form_id', $id)
            ->where('nourut', '!=', 0)
            ->orderByDesc('nourut')->get();
    }

    public function formdetail($id)
    {
        $form = Form::find($id);
        return view('pages.portal.form.form.formdetail', [
            'breadcrumb' => [
                'Home' => '/',
                'Form Sidang' => '/form',
                'Form Detail' => '/'
            ],
            'activeMenu' => $this->activeMenu,
            'form_id' => $id,
            'nouruts' => $this->getNoUrut($id)

        ]);
    }

    public function formdetailStore(Request $request)
    {

        if ($request->jenis == 'Tambah Judul') {
            $rules = [
                'form_id' => 'required|integer',
                'nourut' => 'required|integer',
                'deskripsi' => 'required|regex:"^[a-zA-Z0-9\./& ]+$"',
                'bobot' => 'nullable|integer',
            ];
            $dataValidated = $request->validate($rules);
            $dataValidated['jenis'] = 'judul';
        } else {
            $rules = [
                'form_id' => 'required|integer',
                'parent_id' => 'required|integer',
                'deskripsi' => 'required|regex:"^[a-zA-Z0-9\./& ]+$"',
                'bobot' => 'required|integer',
            ];
            $dataValidated = $request->validate($rules);
            $dataValidated['jenis'] = 'subjudul';
        }

        if (!empty($request->id)) {
            Formdetail::find($request->id)->update($dataValidated);
        } else {
            Formdetail::create($dataValidated);
        }
        Form::find($dataValidated['form_id'])->touch();

        return back()->with('success', 'Data berhasil disimpan');
    }

    public function formdetailDestroy($id)
    {
        $form = Formdetail::find($id);
        Formdetail::where('parent_id', $form->nourut)
            ->where('form_id', $form->form_id)->delete();
        Formdetail::destroy($id);
        return back()->with('success', 'Data berhasil dihapus');
    }

    // Form prodi

    public function prodi(Request $request)
    {
        return view('pages.portal.form.prodi.index', [
            'breadcrumb' => [
                'Home' => '/',
                'Form' => '/',
                'Form Prodi' => '/'
            ],
            'activeMenu' => $this->activeMenuProdi,

        ]);
    }

    public function prodiform()
    {
        return view('pages.portal.form.prodi.form', [
            'breadcrumb' => [
                'Home' => '/',
                'Form' => '',
                'Form Prodi' => '/form/prodi',
                'Form Tambah' => '/'
            ],
            'activeMenu' => $this->activeMenuProdi,
            'prodis' => $this->getProdiCombo(),
            'forms' => $this->getFormCombo(),

        ]);
    }

    public function prodistore(Request $request)
    {
        $rules = [
            'prodi_id' => 'required|integer|unique:formprodis,prodi_id,NULL,id,form_id,' . $request->form_id . '',
            'form_id' => 'required|integer|unique:formprodis,form_id,NULL,id,prodi_id,' . $request->prodi_id . '',
        ];

        $dataValidated = $request->validate($rules);

        if ($request->id) {
            Formprodi::find($request->id)->update($dataValidated);
        } else {
            Formprodi::create($dataValidated);
        }

        return redirect('/form/prodi')->with('success', 'Data berhasil disimpan');
    }

    public function prodiedit($id)
    {
        return view('pages.portal.form.prodi.form', [
            'breadcrumb' => [
                'Home' => '/',
                'Form' => '/',
                'Form Prodi' => '/form/prodi',
                'Form Edit' => '/'
            ],
            'activeMenu' => $this->activeMenuProdi,
            'data' => Formprodi::find($id),
            'id' => $id,
            'prodis' => $this->getProdiCombo(),
            'forms' => $this->getFormCombo(),

        ]);
    }

    public function prodiupdate(Request $request)
    {
        $rules = [
            'prodi_id' => 'required|integer|unique:formprodis,prodi_id,NULL,id,form_id,' . $request->form_id . '',
            'form_id' => 'required|integer|unique:formprodis,form_id,NULL,id,prodi_id,' . $request->prodi_id . '',
        ];

        $dataValidated = $request->validate($rules);

        Formprodi::find($request->id)
            ->update($dataValidated);


        return redirect('/form/prodi')->with('success', 'Data berhasil disimpan');
    }

    public function prodidestroy($id)
    {
        Formprodi::destroy($id);
        return redirect('/form/prodi')->with('success', 'Data berhasil dihapus');
    }

    public function prodilist(Request $request)
    {

        if ($request->ajax()) {
            $data = Formprodi::with(['prodi', 'form'])->orderBy('prodi_id');

            return DataTables::of($data)
                ->addIndexColumn()
                ->addColumn('action', function (Formprodi $fmprodi) {
                    $actionBtn = '
                <a href="' . url('/form/prodi/edit/' . $fmprodi->id) . '" class="edit btn btn-primary btn-xs"><i class="fas fa-edit fa-sm" title="Edit"></i></a> 
                <a href="javascript:void(0)" class="delete btn btn-danger btn-xs" title="Hapus" data-toggle="modal" data-target="#del' . $fmprodi->id . '"><i class="fas fa-trash fa-sm"></i></a>
                    <div class="modal fade" id="del' . $fmprodi->id . '">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-body text-left pb-0">
                                <h4>Hapus data</h4>
                                    <p>Data yang dihapus tidak bisa dipulihkan kembali</p>
                                </div>
                                <div class="modal-footer pt-0 border-0 justify-content-end">
                                    <form action="' . url("/form/prodi/delete/" . $fmprodi->id . "") . '" method="post">
                                        <input type="hidden" name="_method" value="DELETE">
                                        <input type="hidden" name="_token" value="' . csrf_token() . '">
                                        <a href="javascript:void(0)" class="btn mr-2" data-dismiss="modal">Kembali</a>
                                        <button class="btn btn-danger">Hapus</button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                    ';
                    return $actionBtn;
                })
                ->rawColumns(['action'])
                ->make(true);
        }
    }
}
