<?php

namespace App\Http\Controllers;

use App\Models\User;
use App\Models\Dosen;
use Illuminate\Support\Str;
use Illuminate\Http\Request;
use App\Imports\DosenImport;
use App\Exports\DosenExport;
use App\Exports\TemplateDosen;
use Maatwebsite\Excel\Facades\Excel;
use Yajra\DataTables\Facades\DataTables;

class DosenController extends Controller
{
    private $activeMenu = 'Home/Dosen';

    public function index(Request $request)
    {
        return view('pages.portal.master.dosen.index', [
            'breadcrumb' => [
                'Home' => '/',
                'Master' => '/',
                'Dosen' => '/'
            ],
            'activeMenu' => $this->activeMenu,

        ]);
    }

    public function list(Request $request)
    {

        // if ($req->ajax()) {
        $data = Dosen::query()->orderBy('updated_at', 'desc');

        return DataTables::of($data)
            ->addIndexColumn()
            ->addColumn('action', function (Dosen $mhs) {
                $actionBtn = '<a href="' . url("/dosen/edit/" . $mhs->id . "") . '" class="edit btn btn-primary btn-xs"><i class="fas fa-edit fa-sm" title="Edit"></i></a> <a href="javascript:void(0)" class="delete btn btn-danger btn-xs" title="Hapus" data-toggle="modal" data-target="#del' . $mhs->id . '"><i class="fas fa-trash fa-sm"></i></a>
                    <div class="modal fade" id="del' . $mhs->id . '">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-body text-left pb-0">
                                <h4>Hapus data</h4>
                                    <p>Data yang dihapus tidak bisa dipulihkan kembali</p>
                                </div>
                                <div class="modal-footer pt-0 border-0 justify-content-end">
                                    <form action="' . url("/dosen/delete/" . $mhs->id . "") . '" method="post">
                                        <input type="hidden" name="_method" value="DELETE">
                                        <input type="hidden" name="_token" value="' . csrf_token() . '">
                                        <a href="javascript:void(0)" class="btn mr-2" data-dismiss="modal">Kembali</a>
                                        <button class="btn btn-danger">Hapus</button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                    ';
                return $actionBtn;
            })
            ->rawColumns(['action'])
            ->make(true);
        // }

    }

    public function form(Request $request)
    {
        return view('pages.portal.master.dosen.form', [
            'breadcrumb' => [
                'Home' => '/',
                'Master' => '/',
                'Dosen' => '/user',
                'Form Tambah' => '/'
            ],
            'activeMenu' => $this->activeMenu,

        ]);
    }

    public function store(Request $request, Dosen $user)
    {
        $rules = [
            'nidn' => 'required|numeric|unique:dosens',
            'kode' => 'required|min:3|max:3|unique:dosens',
            'nama' => 'required|min:3',
        ];

        $dataValidated = $request->validate($rules);
        $dataUser = [
            'name' => $dataValidated['nama'],
            'username' => $dataValidated['kode'],
            'password' => bcrypt($dataValidated['nidn']),
            'access' => 1,
            'role' => 'dosen',
        ];

        Dosen::create($dataValidated);
        User::create($dataUser);

        return redirect('/dosen')->with('success', 'Data berhasil disimpan');
    }

    public function edit($id)
    {
        return view('pages.portal.master.dosen.form', [
            'breadcrumb' => [
                'Home' => '/',
                'Master' => '/',
                'Dosen' => '/dosen',
                'Form Edit' => '/'
            ],
            'activeMenu' => $this->activeMenu,
            'data' => Dosen::find($id),
            'id' => $id

        ]);
    }

    public function update(Request $request)
    {
        $rules = [
            'nidn' => 'required|min:6',
            'kode' => 'required',
            'nama' => 'required'
        ];

        $dataValidated = $request->validate($rules);

        $dataUser = [
            'name' => $dataValidated['nama']
        ];

        Dosen::find($request->id)
            ->update($dataValidated);

        User::where('username', $request->nim)
            ->update($dataUser);


        return redirect('/dosen')->with('success', 'Data berhasil disimpan');
    }

    public function destroy($id)
    {
        $dosen = Dosen::find($id);
        User::where('username', $dosen->kode)->delete();
        Dosen::destroy($id);
        return redirect('/dosen')->with('success', 'Data berhasil dihapus');
    }

    function template(Request $request)
    {

        return Excel::download(new TemplateDosen, 'Template-Dosen.xlsx');
    }

    function import(Request $request)
    {
        $file = $request->validate([
            'file' => 'required'
        ]);
        $import = new DosenImport;
        Excel::import($import, $request->file('file'));
        return back()->with('success', $import->getSuccessRowCount() . ' dari ' . $import->getRowCount() . ' data berhasil disimpan');;
    }

    function export(Request $request)
    {
        return Excel::download(new DosenExport, 'Data-Dosen-' . date('Ymd') . '.xlsx');
    }
}
