<?php

namespace App\Http\Controllers;

use App\Models\Form;
use App\Models\User;
use App\Models\Dosen;
use App\Models\Prodi;
use App\Models\Periode;
use App\Models\Formprodi;
use App\Models\Mahasiswa;
use App\Models\Notification;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Routing\Controller as BaseController;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;

class Controller extends BaseController
{
    use AuthorizesRequests, DispatchesJobs, ValidatesRequests;

    public function formPeriodeList()
    {
        $periode = [];
        for ($i = 1; $i < 3; $i++) {
            $periode[] = date('Y') . '' . $i;
        }

        return $periode;
    }

    public function getPeriodeList()
    {
        $periode = [];
        for ($i = date('Y'); $i > 2020; $i--) {
            $periode[] = $i;
        }

        return $periode;
    }

    public function setPeriodeSession()
    {
        $periodeTor = Periode::where('active', 1)
            ->where('nama', 'tor')
            ->first();

        $periodeSidang = Periode::where('active', 1)
            ->where('nama', 'sidang')
            ->first();

        session([
            'periode_tor' => $periodeTor->periode,
            'tgl_awal_tor' => $periodeTor->tgl_awal,
            'tgl_akhir_tor' => $periodeTor->tgl_akhir,
            'periode_sidang' => $periodeSidang->periode,
            'bulan_sidang' => $periodeSidang->bulan,
            'tgl_awal_sidang' => $periodeSidang->tgl_awal,
            'tgl_akhir_sidang' => $periodeSidang->tgl_akhir,
        ]);
    }

    public function getKelasCombo()
    {
        $data = [];
        for ($i = 1; $i < 9; $i++) {
            $data[] = $i . 'A';
            $data[] = $i . 'B';
        }

        return $data;
    }

    public function getPeriodeTorCombo()
    {
        $periodes = Periode::where('nama', 'tor')->orderByDesc('periode')->get();
        $data = [];
        foreach ($periodes as $periode) {
            $data[$periode->periode] = $periode->periode;
        }

        return $data;
    }

    public function getPeriodeSidangCombo()
    {
        $periodes = Periode::where('nama', 'sidang')->orderByDesc('periode')->get();
        $data = [];
        foreach ($periodes as $periode) {
            $data[$periode->periode] = $periode->periode;
        }

        return $data;
    }

    public function getBulanSidangCombo()
    {
        $bulans = Periode::where('nama', 'sidang')->distinct()->get();
        $data = [];
        foreach ($bulans as $bulan) {
            $data[$bulan->bulan] = $bulan->bulan;
        }

        return $data;
    }

    public function getMhsCombo()
    {
        $mahasiswas = Mahasiswa::orderBy('nim')->get();
        $data = [];
        foreach ($mahasiswas as $mhs) {
            $data[$mhs->id] = $mhs->nim . ' | ' . $mhs->nama;
        }

        return $data;
    }

    public function getProdiCombo()
    {
        $where = '';
        if (auth()->user()->role == 'admin prodi' || auth()->user()->role == 'kaprodi') {
            $where .= ' AND id=' . auth()->user()->position;
        }
        $prodis = Prodi::whereRaw('1 ' . $where)->orderBy('kode')->get();
        $data = [];
        foreach ($prodis as $prodi) {
            $data[$prodi->id] = $prodi->kode . ' | ' . $prodi->prodi;
        }

        return $data;
    }

    public function getPembimbingCombo()
    {
        $user = User::find(auth()->id());
        $mhs = Mahasiswa::where('nim', $user->username)->first();

        $dosens = Dosen::whereRaw('id IN (' . $mhs->sidang->pbb1_net . ',' . $mhs->sidang->pbb2_net . ')')->orderBy('kode')->get();
        $data = [];
        foreach ($dosens as $dosen) {
            $data[$dosen->id] = $dosen->kode . ' | ' . $dosen->nama;
        }

        return $data;
    }

    public function getDosenCombo()
    {
        $dosens = Dosen::orderBy('kode')->get();
        $data = [];
        foreach ($dosens as $dosen) {
            $data[$dosen->id] = $dosen->kode . ' | ' . $dosen->nama;
        }

        return $data;
    }

    public function getFormCombo($where = '')
    {
        $forms = Form::whereRaw('1' . $where)
            ->orderBy('nama')->get();
        $data = [];
        foreach ($forms as $form) {
            $data[$form->id] = $form->nama;
        }

        return $data;
    }

    public function getFormProdiCombo($where = '')
    {
        $forms = Formprodi::whereRaw('1' . $where)
            ->orderBy('form_id')->get();
        $data = [];
        foreach ($forms as $form) {
            $data[$form->form_id] = $form->form->nama;
        }

        return $data;
    }

    public function getVerifikatorCombo()
    {
        $users = User::where('verifikator', 1)
            ->whereRaw('role NOT IN ("admin","admin adak", "kaprodi")')
            ->orderBy('role')->get();
        $data = [];
        foreach ($users as $usr) {
            $data[$usr->id] = $usr->name . ' (' . $usr->role . ')';
        }
        $data[0] = 'Kaprodi';

        return $data;
    }

    public function notificationStore($receiver = 0, $role = null, $sender, $text)
    {
        Notification::create([
            'receiver' => $receiver,
            'role' => $role,
            'sender' => $sender,
            'text' => $text,
        ]);
    }

    public function getHariCombo()
    {
        $data = [];
        $data[''] = '-- Hari --';
        $data['Senin'] = 'Senin';
        $data['Selasa'] = 'Selasa';
        $data['Rabu'] = 'Rabu';
        $data['Kamis'] = 'Kamis';
        $data['Jumat'] = 'Jumat';

        return $data;
    }

    public function hitungNa($up, $pbb1, $pbb2, $pji1, $pji2)
    {
        $na = (((($pbb1 + $pbb2) * 3) + (($pji1 + $pji2) * 2)) + ($up * 2)) / 12;

        $na = number_format($na, 2, '.');
        return $na;
    }

    public function periode($periode)
    {
        return substr($periode, 0, 4) . '-' . substr($periode, 4, 1);
    }

    public function getIndex($na)
    {
        if ($na >= 3.51 && $na <= 4) {
            $index = 'A';
        }

        if ($na >= 2.60 && $na <= 3.50) {
            $index = 'B';
        }

        if ($na >= 2.00 && $na <= 2.59) {
            $index = 'C';
        }

        if ($na >= 1.00 && $na <= 1.99) {
            $index = 'D';
        }

        if ($na <= 1.00) {
            $index = 'E';
        }

        return $index;
    }

    public function getKonversi($index)
    {
        if ($index == 'A')
            $konversi = 4;

        if ($index == 'B')
            $konversi = 3;

        if ($index == 'C')
            $konversi = 2;

        if ($index == 'D')
            $konversi = 1;

        if ($index == 'E')
            $konversi = 0;

        return $konversi;
    }

    public function getFinalNa($konversi, $sks, $tot_bobot, $tot_sks)
    {
        $finalNa = (($konversi * $sks) + $tot_bobot) / $tot_sks;
        $finalNa = number_format($finalNa, 2, '.');
        return $finalNa;
    }

    public function getYudisium($finalNa, $jenjang)
    {
        $yudisium = 'Tdk Lulus';
        $finalNa = number_format($finalNa, 2, '.');

        if ($jenjang == 'S2') {
            if ($finalNa >= 2.75 && $finalNa <= 3.40) {
                $yudisium = 'Memuaskan';
            }

            if ($finalNa >= 3.41 && $finalNa <= 3.75) {
                $yudisium = 'Sangat Memuaskan';
            }

            if ($finalNa >= 3.76 && $finalNa <= 4.00) {
                $yudisium = 'Dengan Pujian';
            }
        } else {
            if ($finalNa >= 2.00 && $finalNa <= 2.75) {
                $yudisium = 'Memuaskan';
            }

            if ($finalNa >= 2.76 && $finalNa <= 3.50) {
                $yudisium = 'Sangat Memuaskan';
            }

            if ($finalNa >= 3.51 && $finalNa <= 4.00) {
                $yudisium = 'Dengan Pujian';
            }
        }

        return $yudisium;
    }

    public function cekLulus($yudisium)
    {
        if ($yudisium == 'Memuaskan' || $yudisium == 'Sangat Memuaskan' || $yudisium == 'Dengan Pujian') {
            $status = 'LULUS';
        } elseif ($yudisium == '') {
            $status = '-';
        } else {
            $status = 'TIDAK LULUS';
        }

        return $status;
    }
}
