<?php
/*
*********************************************************************************************************
* daloRADIUS - RADIUS Web Platform
* Copyright (C) 2007 - Liran Tal <liran@enginx.com> All Rights Reserved.
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*
*********************************************************************************************************
* Description:
*		English language file
*
* Authors:	Liran Tal <liran@enginx.com>
*
*********************************************************************************************************
*/

$l['all']['daloRADIUS'] = "daloRADIUS " . $configValues['DALORADIUS_VERSION'];
$l['all']['daloRADIUSVersion'] = "version " . $configValues['DALORADIUS_VERSION'];
$l['all']['copyright1'] = "RADIUS は <a href=\"https://github.com/lirantal/daloradius\">Liran Tal</a>によって管理、レポート、アカウンティング、課金されています。";
$l['all']['copyright2'] = "daloRADIUS Copyright &copy; 2007-2019 by <a href=\"https://github.com/lirantal/daloradius\">Liran Tal</a> <br/>Template design by <a href=\"http://www.sixshootermedia.com\">Six Shooter Media</a>.";
$l['all']['ID'] = "ID";
$l['all']['PoolName'] = "プール名";
$l['all']['CalledStationId'] = "呼び出されたステーションID";
$l['all']['CallingStationID'] = "呼び出すステーションID";
$l['all']['ExpiryTime'] = "期限切れ時間";
$l['all']['PoolKey'] = "プールキー";

/********************************************************************************/
/* Vendor Attributes related translation                                        */
/********************************************************************************/
$l['all']['Dictionary'] = "ディレクトリ";
$l['all']['VendorID'] = "ベンダID";
$l['all']['VendorName'] = "ベンダ名";
$l['all']['VendorAttribute'] = "ベンダ属性";
$l['all']['RecommendedOP'] = "推奨OP";
$l['all']['RecommendedTable'] = "推奨テーブル";
$l['all']['RecommendedTooltip'] = "推奨ツールチップ";
$l['all']['RecommendedHelper'] = "推奨ヘルパー";
/********************************************************************************/

$l['all']['CSVData'] = "CSV形式データ";

$l['all']['CPU'] = "CPU";

/* radius related text */
$l['all']['RADIUSDictionaryPath'] = "RADIUSディレクトリパス";

$l['all']['DashboardSecretKey'] = "ダッシュボード秘密鍵";
$l['all']['DashboardDebug'] = "デバッグ";
$l['all']['DashboardDelaySoft'] = "'soft'遅延制限と判定する時間(分)";
$l['all']['DashboardDelayHard'] = "'hard'遅延制限と判定する時間(分)";

$l['all']['SendWelcomeNotification'] = "ウェルカム通知の送信";
$l['all']['SMTPServerAddress'] = "SMTPサーバアドレス";
$l['all']['SMTPServerPort'] = "SMTPサーバポート";
$l['all']['SMTPServerFromEmail'] = "送信元Emailアドレス";

$l['all']['customAttributes'] = "カスタム属性";
$l['all']['UserType'] = "ユーザタイプ";
$l['all']['BatchName'] = " バッチ名";
$l['all']['BatchStatus'] = "パッチ状態";
$l['all']['Users'] = "ユーザ";
$l['all']['Compare'] = "比較";

$l['all']['Never'] = "なし";

$l['all']['Section'] = "セクション";
$l['all']['Item'] = "アイテム";

$l['all']['Megabytes'] = "メガバイト";
$l['all']['Gigabytes'] = "ギガバイト";

$l['all']['Daily'] = "日";
$l['all']['Weekly'] = "週";
$l['all']['Monthly'] = "月";
$l['all']['Yearly'] = "年";

$l['all']['Month'] = "月";

$l['all']['RemoveRadacctRecords'] = "アカウンティングレポート削除";

$l['all']['CleanupSessions'] = "指定より古いセッションのクリア";
$l['all']['DeleteSessions'] = "指定より古いセッションの削除";

$l['all']['StartingDate'] = "開始日";
$l['all']['EndingDate'] = "終了日";

$l['all']['Realm'] = "レルム";
$l['all']['RealmName'] = "レルム名";
$l['all']['RealmSecret'] = "レルムシークレット";
$l['all']['AuthHost'] = "認証ホスト";
$l['all']['AcctHost'] = "アカウンティングホスト";

$l['all']['Ldflag'] = "ldflag";
$l['all']['Nostrip'] = "nostripオプション";
$l['all']['Notrealm'] = "notrealmオプション";
$l['all']['Hints'] = "hintsオプション";

$l['all']['Proxy'] = "プロキシ";
$l['all']['ProxyName'] = "プロキシ名";
$l['all']['ProxySecret'] = "プロキシシークレット";
$l['all']['DeadTime'] = "停止判定時間";
$l['all']['RetryDelay'] = "リトライ感覚";
$l['all']['RetryCount'] = "リトライ数";
$l['all']['DefaultFallback'] = "デフォルトフォールバック";


$l['all']['Firmware'] = "ファームウェア";
$l['all']['NASMAC'] = "NAS MACアドレス";

$l['all']['WanIface'] = "WAN インターフェース";

$l['all']['WanMAC'] = "WAN MACアドレス";

$l['all']['WanIP'] = "WAN IPアドレス";

$l['all']['WanGateway'] = "WAN ゲートウェイ";

$l['all']['LanIface'] = "LAN インターフェース";

$l['all']['LanMAC'] = "LAN MACアドレス";

$l['all']['LanIP'] = "LAN IPアドレス";


$l['all']['WifiIface'] = "Wifi インターフェース";

$l['all']['WifiMAC'] = "Wifi MACアドレス";

$l['all']['WifiIP'] = "Wifi IPアドレス";

$l['all']['WifiSSID'] = "Wifi SSID";

$l['all']['WifiKey'] = "Wifi 暗号化キー";

$l['all']['WifiChannel'] = "Wifi チャンネル";

$l['all']['CheckinTime'] = "最終チェックイン";

$l['all']['FramedIPAddress'] = "Framed-IP-Address属性";

$l['all']['SimultaneousUse'] = "Simultaneous-Use属性";

$l['all']['HgID'] = "ハントグループ ID";

$l['all']['Hg'] = "ハントグループ ";
$l['all']['HgIPHost'] = "ハントグループ IP/ホスト";
$l['all']['HgGroupName'] = "ハントグループ名";
$l['all']['HgPortId'] = "ハントグループポート ID";


$l['all']['NasID'] = "NAS ID";
$l['all']['Nas'] = "NAS ";
$l['all']['Nas'] = "NAS ";
$l['all']['NasIPHost'] = "NAS IP/ホスト";
$l['all']['NasShortname'] = "NAS 短い名前";
$l['all']['NasType'] = "NASタイプ";
$l['all']['NasPorts'] = "NASポート";
$l['all']['NasSecret'] = "NASシークレット";
$l['all']['NasCommunity'] = "NASコミュニティ";
$l['all']['NasDescription'] = "NAS説明";
$l['all']['PacketType'] = "パケットタイプ";
$l['all']['HotSpot'] = "ホットスポット";
$l['all']['HotSpots'] = "ホットスポット";
$l['all']['HotSpotName'] = "ホットスポット名";
$l['all']['Name'] = "名称";
$l['all']['Username'] = "ユーザ名";
$l['all']['Password'] = "パスワード";
$l['all']['PasswordType'] = "パスワードタイプ";
$l['all']['IPAddress'] = "IPアドレス";
$l['all']['Profile'] = "プロファイル";
$l['all']['Group'] = "グループ";
$l['all']['Groupname'] = "グループ名";
$l['all']['ProfilePriority'] = "プロファイル優先度";

$l['all']['GroupPriority'] = "グループ優先度";
$l['all']['CurrentGroupname'] = "現在のグループ名";
$l['all']['NewGroupname'] = "新しいグループ名";

$l['all']['Priority'] = "優先度";

$l['all']['Attribute'] = "属性";
$l['all']['Operator'] = "オペレータ";

$l['all']['Value'] = "値";
$l['all']['NewValue'] = "新しい値";

$l['all']['MaxTimeExpiration'] = "アカウント有効期限";

$l['all']['UsedTime'] = "利用時間";

$l['all']['Status'] = "ステータス";
$l['all']['Usage'] = "利用状況";

$l['all']['StartTime'] = "開始時間";
$l['all']['StopTime'] = "停止時間";
$l['all']['TotalTime'] = "合計時間";
$l['all']['TotalTraffic'] = "合計通信量";
$l['all']['Bytes'] = "バイト";
$l['all']['Upload'] = "アップロード";
$l['all']['Download'] = "ダウンロード";
$l['all']['Rollback'] = "ロールバック";
$l['all']['Termination'] = "課金終了";
$l['all']['NASIPAddress'] = "NAS IPアドレス";
$l['all']['NASShortName'] = "NAS短い名前";
$l['all']['Action'] = "アクション";

$l['all']['UniqueUsers'] = "ユニークユーザ";
$l['all']['TotalHits'] = "総ヒット数";
$l['all']['AverageTime'] = "平均時間";
$l['all']['Records'] = "レコード";


$l['all']['Summary'] = "概要";
$l['all']['Statistics'] = "統計";
$l['all']['Credit'] = "クレジット";
$l['all']['Used'] = "使用済み";
$l['all']['LeftTime'] = "残り時間";
$l['all']['LeftPercent'] = "残り時間 %";
$l['all']['TotalSessions'] = "総セッション数";
$l['all']['LastLoginTime'] = "最終ログイン時刻";
$l['all']['TotalSessionTime'] = "総セッション時間";


$l['all']['RateName'] = "レート名";
$l['all']['RateType'] = "レートタイプ";
$l['all']['RateCost'] = "レートコスト";

$l['all']['Billed'] = "請求";


$l['all']['TotalUsers'] = "ユーザ数合計";
$l['all']['ActiveUsers'] = "アクティブユーザ数";

$l['all']['TotalBilled'] = "請求総額";
$l['all']['TotalPayed'] = "支払総額";
$l['all']['Balance'] = "差額";

$l['all']['CardBank'] = "カードバンク";
$l['all']['Type'] = "タイプ";
$l['all']['MACAddress'] = "MACアドレス";
$l['all']['Geocode'] = "GEOコード";
$l['all']['PINCode'] = "PINコード";
$l['all']['CreationDate'] = "登録日";
$l['all']['CreationBy'] = "登録者";
$l['all']['UpdateDate'] = "更新日";
$l['all']['UpdateBy'] = "更新者";

$l['all']['Discount'] = "割引き";
$l['all']['BillAmount'] = "請求額";
$l['all']['BillAction'] = "請求アクション";
$l['all']['BillPerformer'] = "請求者";
$l['all']['BillReason'] = "請求理由";

$l['all']['Lead'] = "Lead";
$l['all']['Coupon'] = "クーポン";

$l['all']['OrderTaker'] = "受付担当者";
$l['all']['BillStatus'] = "請求ステータス";
$l['all']['LastBill'] = "最近の請求";
$l['all']['NextBill'] = "次の請求";
$l['all']['BillDue'] = "請求理由";
$l['all']['NextInvoiceDue'] = "次の請求書の日付";
$l['all']['PostalInvoice'] = "郵送請求書";
$l['all']['FaxInvoice'] = "ファックス請求書";
$l['all']['EmailInvoice'] = "Eメール請求書";

$l['all']['ClientName'] = "クライアント名";
$l['all']['Date'] = "日付";

$l['all']['edit'] = "編集";
$l['all']['del'] = "削除";

$l['all']['groupslist'] = "グループ一覧";

$l['all']['TestUser'] = "ユーザの接続テスト";
$l['all']['Accounting'] = "アカウンティング";

$l['all']['RADIUSReply'] = "RADIUS リプライ";

$l['all']['Disconnect'] = "切断";

$l['all']['Debug'] = "デバッグ";
$l['all']['Timeout'] = "タイムアウト";
$l['all']['Retries'] = "リトライ";
$l['all']['Count'] = "カウント";
$l['all']['Requests'] = "リクエスト";

$l['all']['DatabaseHostname'] = "データベースホスト名";
$l['all']['DatabasePort'] = "データベースポート番";
$l['all']['DatabaseUser'] = "データベース接続ユーザ";
$l['all']['DatabasePass'] = "データベース接続パスワード";
$l['all']['DatabaseName'] = "データベース名";

$l['all']['PrimaryLanguage'] = "主言語";

$l['all']['PagesLogging'] = "ページのロギング(ページ訪問)";
$l['all']['QueriesLogging'] = "クエリのロギング(レポートとグラフ)";
$l['all']['ActionsLogging'] = "アクションのロギング(フォーム適用)";
$l['all']['FilenameLogging'] = "ロギングのファイル名(フルパス)";
$l['all']['LoggingDebugOnPages'] = "ページのデバッグ情報のロギング";
$l['all']['LoggingDebugInfo'] = "デバッグ情報のロギング";

$l['all']['PasswordHidden'] = "パスワード隠蔽(アスタリスクで表示)";
$l['all']['TablesListing'] = "一覧ページの行数";
$l['all']['TablesListingNum'] = "一覧ページのナンバリング";
$l['all']['AjaxAutoComplete'] = "Ajaxの自動補完";

$l['all']['RadiusServer'] = "RADIUS サーバ";
$l['all']['RadiusPort'] = "RADIUS ポート";

$l['all']['UsernamePrefix'] = "ユーザ名の接頭語";
$l['all']['batchName'] = "バッチ ID/名";
$l['all']['batchDescription'] = "バッチの説明";
$l['all']['NumberInstances'] = "作成するインスタンス数";
$l['all']['UsernameLength'] = "ユーザ名文字数";
$l['all']['PasswordLength'] = "パスワード文字数";

$l['all']['Expiration'] = "Expiration属性";
$l['all']['MaxAllSession'] = "Max-All-Session属性";
$l['all']['SessionTimeout'] = "Session-Timeout属性";
$l['all']['IdleTimeout'] = "Idle-Timeout属性";

$l['all']['DBEngine'] = "DBエンジン";
$l['all']['radcheck'] = "radcheckテーブル";
$l['all']['radreply'] = "radreplyテーブル";
$l['all']['radgroupcheck'] = "radgroupcheckテーブル";
$l['all']['radgroupreply'] = "radgroupreplyテーブル";
$l['all']['usergroup'] = "usergroupテーブル";
$l['all']['radacct'] = "radacctテーブル";
$l['all']['operators'] = "オペレータ";
$l['all']['operators_acl'] = "オペレータACL";
$l['all']['operators_acl_files'] = "オペレータACLファイル";
$l['all']['billingrates'] = "課金レート";
$l['all']['hotspots'] = "ホットスポット";
$l['all']['node'] = "ノード";
$l['all']['nas'] = "NAS";
$l['all']['hunt'] = "RADIUSハントグループ";
$l['all']['radpostauth'] = "RADIUS postauth";
$l['all']['radippool'] = "RADIUS IPプール";
$l['all']['userinfo'] = "ユーザー情報";
$l['all']['dictionary'] = "辞書";
$l['all']['realms'] = "レルム";
$l['all']['proxys'] = "プロキシ";
$l['all']['billingpaypal'] = "PayPal 請求";
$l['all']['billingmerchant'] = "課金業者";
$l['all']['billingplans'] = "課金プラン";
$l['all']['billinghistory'] = "請求履歴";
$l['all']['billinginfo'] = "課金ユーザ情報";

$l['all']['CreateIncrementingUsers'] = "連番でユーザを作る";
$l['all']['CreateRandomUsers'] = "ランダム文字でユーザを作る";
$l['all']['StartingIndex'] = "開始番号";
$l['all']['EndingIndex'] = "終了番号";
$l['all']['RandomChars'] = "ランダム許可文字";

$l['all']['Memfree'] = "メモリ解放";
$l['all']['Uptime'] = "連続稼働時間";
$l['all']['BandwidthUp'] = "Bandwidth Up";
$l['all']['BandwidthDown'] = "Bandwidth Down";

$l['all']['BatchCost'] = "バッチコスト";

$l['all']['PaymentDate'] = "支払日";

$l['all']['PaymentStatus'] = "支払い状況";
$l['all']['FirstName'] = "姓";
$l['all']['LastName'] = "名";
$l['all']['VendorType'] = "ベンダー";
$l['all']['PayerStatus'] = "支払者ステータス";
$l['all']['PaymentAddressStatus'] = "支払い者住所ステータス";
$l['all']['PayerEmail'] = "支払者 Eメール";
$l['all']['TxnId'] = "取引ID";

$l['all']['PlanActive'] = "プランをアクティブにする";

$l['all']['PlanTimeType'] = "Plan Time Type";
$l['all']['PlanTimeBank'] = "Plan Time Bank";
$l['all']['PlanTimeRefillCost'] = "Plan Refill Cost";
$l['all']['PlanTrafficRefillCost'] = "Plan Refill Cost";
$l['all']['PlanBandwidthUp'] = "Plan Bandwidth Up";
$l['all']['PlanBandwidthDown'] = "Plan Bandwidth Down";
$l['all']['PlanTrafficTotal'] = "Plan Traffic Total";
$l['all']['PlanTrafficDown'] = "Plan Traffic Down";
$l['all']['PlanTrafficUp'] = "Plan Traffic Up";
$l['all']['PlanRecurring'] = "定期プランにする";
$l['all']['PlanRecurringPeriod'] = "定期プランのサイクル設定";
$l['all']['planRecurringBillingSchedule'] = "定期プラン課金スケジュール";
$l['all']['PlanCost'] = "プラン費用";
$l['all']['PlanSetupCost'] = "プラン設定費用";
$l['all']['PlanTax'] = "プラン税";
$l['all']['PlanCurrency'] = "プラン通貨単位";
$l['all']['PlanGroup'] = "プランプロファイル (グループ)";
$l['all']['PlanType'] = "プランタイプ";
$l['all']['PlanName'] = "プラン名";
$l['all']['PlanId'] = "プランID";

$l['all']['UserId'] = "ユーザ ID";

$l['all']['Invoice'] = "請求書";

$l['all']['InvoiceID'] = "請求書 ID";
$l['all']['InvoiceItems'] = "請求書アイテム";
$l['all']['InvoiceStatus'] = "請求書ステータス";
$l['all']['InvoiceType'] = "請求書タイプ";

$l['all']['Amount'] = "数量";
$l['all']['Total'] = "総計";
$l['all']['TotalInvoices'] = "全ての請求書";

$l['all']['PayTypeName'] = "支払い方式名";
$l['all']['PayTypeNotes'] = "支払い方式説明";
$l['all']['payment_type'] = "支払い方式";
$l['all']['payments'] = "支払い";
$l['all']['PaymentId'] = "支払い ID";
$l['all']['PaymentInvoiceID'] = "請求書 ID";
$l['all']['PaymentAmount'] = "数量";
$l['all']['PaymentDate'] = "日付";
$l['all']['PaymentType'] = "支払い方式";
$l['all']['PaymentNotes'] = "支払いメモ";

$l['all']['Quantity'] = "数量";
$l['all']['ReceiverEmail'] = "受取人 Eメール";
$l['all']['Business'] = "業務";
$l['all']['Tax'] = "税";
$l['all']['Cost'] = "費用";
$l['all']['TotalCost'] = "費用総額";
$l['all']['TransactionFee'] = "取引手数料";
$l['all']['PaymentCurrency'] = "支払い通貨";
$l['all']['AddressRecipient'] = "受取人氏名";
$l['all']['Street'] = "住所";
$l['all']['Country'] = "国";
$l['all']['CountryCode'] = "国コード";
$l['all']['City'] = "市";
$l['all']['State'] = "州";
$l['all']['Zip'] = "郵便番号";

$l['all']['BusinessName'] = "業務名";
$l['all']['BusinessPhone'] = "業務電話番号";
$l['all']['BusinessAddress'] = "業務住所";
$l['all']['BusinessWebsite'] = "業務ウェブサイト";
$l['all']['BusinessEmail'] = "業務 Eメール";
$l['all']['BusinessContactPerson'] = "業務連絡担当者";
$l['all']['DBPasswordEncryption'] = "DBパスワード暗号化形式";


/* **********************************************************************************
* Tooltips
* Helper information such as tooltip text for mouseover events and popup tooltips
************************************************************************************/

$l['Tooltip']['batchNameTooltip'] = "作成するバッチの識別名を入力してください";
$l['Tooltip']['batchDescriptionTooltip'] = "作成するバッチに関する説明を入力してください";
$l['Tooltip']['hotspotTooltip'] = "バッチインスタンスが紐付いているホットスポット名を選択してください";
$l['Tooltip']['startingIndexTooltip'] = "作成するユーザーの開始番号を入力してください";
$l['Tooltip']['planTooltip'] = "ユーザと関連付けるプランを選択してください";

$l['Tooltip']['InvoiceEdit'] = "請求書を編集する";

$l['Tooltip']['invoiceTypeTooltip'] = "";
$l['Tooltip']['invoiceStatusTooltip'] = "";

$l['Tooltip']['invoiceID'] = "請求書IDを入力してください";

$l['Tooltip']['amountTooltip'] = "";

$l['Tooltip']['taxTooltip'] = "";

$l['Tooltip']['PayTypeName'] = "支払い方式名を入力してください";

$l['Tooltip']['EditPayType'] = "支払い方式の編集";
$l['Tooltip']['RemovePayType'] = "支払い方式の削除";

$l['Tooltip']['paymentTypeTooltip'] = "支払い方式の名前。<br/>
支払いの目的がわかりやすい名前をつけます";
$l['Tooltip']['paymentTypeNotesTooltip'] = "支払い方式の説明。<br/>
支払い方式の使い方を説明します";

$l['Tooltip']['EditPayment'] = "支払いの編集";

$l['Tooltip']['PaymentId'] = "支払いID";

$l['Tooltip']['RemovePayment'] = "支払いの削除";

$l['Tooltip']['paymentInvoiceTooltip'] = "この支払いに関係する請求書";

$l['Tooltip']['Username'] = "ユーザ名を入力してください";

$l['Tooltip']['BatchName'] = "バッチ名を入力してください";

$l['Tooltip']['UsernameWildcard'] = "ヒント: ワイルドカードに 「*」 または 「%」 が使用可能です";

$l['Tooltip']['HotspotName'] = "ホットスポット名を入力してください";

$l['Tooltip']['NasName'] = "NAS名を入力してください";

$l['Tooltip']['GroupName'] = "グループ名を入力してください";

$l['Tooltip']['AttributeName'] = "属性名を入力してください";

$l['Tooltip']['VendorName'] = "ベンダー名を入力してください";

$l['Tooltip']['PoolName'] = "プール名を入力してください";

$l['Tooltip']['IPAddress'] = "IPアドレスを入力してください";

$l['Tooltip']['Filter'] = "フィルターを入力してください。アルファベットと数字が入力できます。すべてのパターンにマッチさせるには空にしてください ";

$l['Tooltip']['Date'] = "日付を入力してください <br/> 例: 1982-06-04 (Y-M-D)";

$l['Tooltip']['RateName'] = "レート名を入力してください";

$l['Tooltip']['OperatorName'] = "運用者名を入力してください";

$l['Tooltip']['BillingPlanName'] = "課金プラン名を入力してください";

$l['Tooltip']['PlanName'] = "プラン名を入力してください";


$l['Tooltip']['EditRate'] = "レートを編集する";

$l['Tooltip']['RemoveRate'] = "レートを削除する";


$l['Tooltip']['rateNameTooltip'] = "レートの目的がわかりやすいレート名を<br/>
入力してください";

$l['Tooltip']['rateTypeTooltip'] = "レートタイプ。レートの動作を決めます";

$l['Tooltip']['rateCostTooltip'] = "レートコスト数";

$l['Tooltip']['planNameTooltip'] = "プランの名称。プランの特徴が<br/>
わかりやすい名前をつけてください";

$l['Tooltip']['planIdTooltip'] = "";

$l['Tooltip']['planTimeTypeTooltip'] = "";

$l['Tooltip']['planTimeBankTooltip'] = "";
$l['Tooltip']['planTimeRefillCostTooltip'] = "";
$l['Tooltip']['planTrafficRefillCostTooltip'] = "";
$l['Tooltip']['planBandwidthUpTooltip'] = "";
$l['Tooltip']['planBandwidthDownTooltip'] = "";
$l['Tooltip']['planTrafficTotalTooltip'] = "";
$l['Tooltip']['planTrafficDownTooltip'] = "";
$l['Tooltip']['planTrafficUpTooltip'] = "";


$l['Tooltip']['planRecurringTooltip'] = "";
$l['Tooltip']['planRecurringBillingScheduleTooltip'] = "";
$l['Tooltip']['planRecurringPeriodTooltip'] = "";
$l['Tooltip']['planCostTooltip'] = "";
$l['Tooltip']['planSetupCostTooltip'] = "";
$l['Tooltip']['planTaxTooltip'] = "";
$l['Tooltip']['planCurrencyTooltip'] = "";
$l['Tooltip']['planGroupTooltip'] = "";


$l['Tooltip']['EditIPPool'] = "IPプールを編集";
$l['Tooltip']['RemoveIPPool'] = "IPプールを削除";

$l['Tooltip']['EditIPAddress'] = "IPアドレスを編集";
$l['Tooltip']['RemoveIPAddress'] = "IPアドレスを削除";

$l['Tooltip']['BusinessNameTooltip'] = "";
$l['Tooltip']['BusinessPhoneTooltip'] = "";
$l['Tooltip']['BusinessAddressTooltip'] = "";
$l['Tooltip']['BusinessWebsiteTooltip'] = "";
$l['Tooltip']['BusinessEmailTooltip'] = "";
$l['Tooltip']['BusinessContactPersonTooltip'] = "";

$l['Tooltip']['proxyNameTooltip'] = "プロキシ名";

$l['Tooltip']['proxyRetryDelayTooltip'] = "プロキシリクエストを送ってから<br/>
再び送るまでのプロキシ応答待ち時間 (秒)";

$l['Tooltip']['proxyRetryCountTooltip'] = "接続を諦めてNASにリジェクトメッセージを<br/>
送るまでのリトライ回数";

$l['Tooltip']['proxyDeadTimeTooltip'] = "複数回リトライしてホームサーバが応答しなければ、<br/>
FreeRADIUS はプロキシリクエストの送信を止め、 <br/>
システム停止とみなす";

$l['Tooltip']['proxyDefaultFallbackTooltip'] = "完全一致のレルムが応答しなければ、以下の措置を試みます <br/>";

$l['Tooltip']['realmNameTooltip'] = "レルム名";
$l['Tooltip']['realmTypeTooltip'] = "デフォルトには radius を設定します";
$l['Tooltip']['realmSecretTooltip'] = "レルム RADIUS 共有鍵";
$l['Tooltip']['realmAuthhostTooltip'] = "レルム認証ホスト";
$l['Tooltip']['realmAccthostTooltip'] = "レルムアカウンティングホスト";
$l['Tooltip']['realmLdflagTooltip'] = "ロードバランシングの許可<br/>
許可値は 'fail_over' と 'round_robin' です";
$l['Tooltip']['realmNostripTooltip'] = "レルム接頭語を除去するか否か";
$l['Tooltip']['realmHintsTooltip'] = "";
$l['Tooltip']['realmNotrealmTooltip'] = "";


$l['Tooltip']['vendorNameTooltip'] = "例: Cisco<br/>&nbsp;&nbsp;&nbsp;
ベンダー名<br/>&nbsp;&nbsp;&nbsp;";

$l['Tooltip']['typeTooltip'] = "例: string<br/>&nbsp;&nbsp;&nbsp;
属性変数型<br/>&nbsp;&nbsp;&nbsp;
(string, integer, date, ipaddr).";

$l['Tooltip']['attributeTooltip'] = "例: Framed-IPAddress<br/>&nbsp;&nbsp;&nbsp;
正確な属性名<br/>&nbsp;&nbsp;&nbsp;";


$l['Tooltip']['RecommendedOPTooltip'] = "例: :=<br/>&nbsp;&nbsp;&nbsp;
推奨された属性の演算子<br/>&nbsp;&nbsp;&nbsp;
(:= == != など...)";
$l['Tooltip']['RecommendedTableTooltip'] = "例: check<br/>&nbsp;&nbsp;&nbsp;
推奨されたターゲットテーブル<br/>&nbsp;&nbsp;&nbsp;
(check または reply).";
$l['Tooltip']['RecommendedTooltipTooltip'] = "例: ユーザのIPアドレス<br/>&nbsp;&nbsp;&nbsp;
推奨されるツールチップ<br/>&nbsp;&nbsp;&nbsp;";

$l['Tooltip']['RecommendedHelperTooltip'] = "この属性を追加するときに利用できる補助関数<br/>&nbsp;&nbsp;&nbsp;
<br/>&nbsp;&nbsp;&nbsp;";

$l['Tooltip']['AttributeEdit'] = "属性編集";

$l['Tooltip']['BatchDetails'] = "バッチ詳細";

$l['Tooltip']['UserEdit'] = "ユーザ編集";

$l['Tooltip']['HotspotEdit'] = "ホットスポット編集";

$l['Tooltip']['EditNAS'] = "NAS編集";

$l['Tooltip']['RemoveNAS'] = "NAS削除";

$l['Tooltip']['EditHG'] = "ハントグループの編集";

$l['Tooltip']['RemoveHG'] = "ハントグループの削除";

$l['Tooltip']['hgNasIpAddress'] = "ホスト/IP を入力してください";
$l['Tooltip']['hgGroupName'] = "NASのグループ名を入力してください";

$l['Tooltip']['hgNasPortId'] = "NAS のポートIDを入力してください";

$l['Tooltip']['EditUserGroup'] = "ユーザグループを編集";

$l['Tooltip']['ListUserGroups'] = "ユーザグループ一覧";

$l['Tooltip']['DeleteUserGroup'] = "ユーザグループの関連付けを削除";


$l['Tooltip']['EditProfile'] = "プロファイル編集";

$l['Tooltip']['EditRealm'] = "レルム編集";

$l['Tooltip']['EditProxy'] = "プロキシ編集";

$l['Tooltip']['EditGroup'] = "グループ編集";

$l['FormField']['mngradgroupcheck.php']['ToolTip']['Value'] = "値を指定すれば、グループ名と指定した値の両方がマッチしたひとつのレコードだけが削除されます。その値を省略した場合、特定のグループ名のすべてのレコードが削除されます。";

$l['FormField']['mngradgroupreplydel.php']['ToolTip']['Value'] = "値を指定すれば、グループ名と指定した値の両方がマッチしたひとつのレコードだけが削除されます。その値を省略した場合、特定のグループ名のすべてのレコードが削除されます。";

$l['FormField']['mngradnasnew.php']['ToolTip']['NasShortname'] = "(記載名)";

$l['FormField']['mngradusergroupdel.php']['ToolTip']['Groupname'] = "値を指定すれば、グループ名と指定した値の両方がマッチしたひとつのレコードだけが削除されます。その値を省略した場合、特定のグループ名のすべてのレコードが削除されます。";

$l['Tooltip']['usernameTooltip'] = "ユーザがシステムに接続できる<br/>&nbsp;&nbsp;&nbsp;
正確なユーザ名を入力してください";

$l['Tooltip']['passwordTypeTooltip'] = "The password type used to authenticate the user in Radius.";
$l['Tooltip']['passwordTooltip'] = "パスワードはシステムによっては大文字小文字を区別しますので、特別な措置が必要です";

$l['Tooltip']['groupTooltip'] = "ユーザはこのグループに追加されます。<br/>&nbsp;&nbsp;&nbsp;
特定のグループにユーザを割り当てることでユーザはグループの属性に従属します。";

$l['Tooltip']['macaddressTooltip'] = "例: 00:AA:BB:CC:DD:EE<br/>&nbsp;&nbsp;&nbsp;
MACアドレス形式はNASが送信する値と同じ形式である必要があります。<br/>&nbsp;&nbsp;&nbsp;
大体の場合、どんな文字も含みません。<br/>&nbsp;&nbsp;&nbsp;";
$l['Tooltip']['pincodeTooltip'] = "例: khrivnxufi101<br/>&nbsp;&nbsp;&nbsp;
これは実際のユーザが入力するような正確な ピンコードです。<br/>&nbsp;&nbsp;&nbsp;
アルファベットと数字が入力でき、大文字小文字は区別されます";

$l['Tooltip']['usernamePrefixTooltip'] = "例: TMP_ POP_ WIFI1_ <br/>&nbsp;&nbsp;&nbsp;
このユーザ名接頭語はユーザ名を作成するときに最後に追加されます<br/>&nbsp;&nbsp;&nbsp;
";
$l['Tooltip']['instancesToCreateTooltip'] = "例: 100<br/>&nbsp;&nbsp;&nbsp;
指定されたプロファイルで作成されるランダムユーザの数<br/>&nbsp;&nbsp;&nbsp;
";

$l['Tooltip']['lengthOfUsernameTooltip'] = "例: 8<br/>&nbsp;&nbsp;&nbsp;
作成されるユーザ名の文字数<br/>&nbsp;&nbsp;&nbsp;
8〜12文字推奨";
$l['Tooltip']['lengthOfPasswordTooltip'] = "例: 8<br/>&nbsp;&nbsp;&nbsp;
作成されるパスワードの文字数<br/>&nbsp;&nbsp;&nbsp;
8〜12文字推奨";


$l['Tooltip']['hotspotNameTooltip'] = "例: Hotel Stratocaster<br/>&nbsp;&nbsp;&nbsp;
ホットスポットのわかりやすい名前<br/>";

$l['Tooltip']['hotspotMacaddressTooltip'] = "例: 00-aa-bb-cc-dd-ee<br/>&nbsp;&nbsp;&nbsp;
NASのMACアドレス<br/>";

$l['Tooltip']['geocodeTooltip'] = "例: -1.002,-2.201<br/>&nbsp;&nbsp;&nbsp;
地図上のホットスポットやNASの場所を指定する、GooleMap のロケーションコード (GIS参照).";

$l['Tooltip']['reassignplanprofiles'] = "ONに変更すると、ユーザ情報を適用するときにプロファイルタブのプロファイル一覧が無視され、プロファイルはプランプロファイル関連付けにもとづいて再割当てされます <br/>
";

/* ********************************************************************************** */




/* **********************************************************************************
* Links and Buttons
************************************************************************************/

$l['button']['DashboardSettings'] = "ダッシュボード設定";

$l['button']['GenerateReport'] = "レポート作成";

$l['button']['ListPayTypes'] = "支払い方式一覧";

$l['button']['NewPayType'] = "支払い方式新規作成";
$l['button']['EditPayType'] = "支払い方式編集";
$l['button']['RemovePayType'] = "支払い方式削除";
$l['button']['ListPayments'] = "支払い一覧";
$l['button']['NewPayment'] = "支払いの新規作成";
$l['button']['EditPayment'] = "支払いの編集";
$l['button']['RemovePayment'] = "支払いの削除";


$l['button']['NewUsers'] = "ユーザの新規作成";


$l['button']['ClearSessions'] = "セッションクリア";

$l['button']['Dashboard'] = "ダッシュボード";

$l['button']['MailSettings'] = "メール設定";


$l['button']['Batch'] = "バッチ";

$l['button']['BatchHistory'] = "バッチ履歴";
$l['button']['BatchDetails'] = "バッチ詳細";

$l['button']['ListRates'] = "レート一覧";
$l['button']['NewRate'] = "レート新規作成";
$l['button']['EditRate'] = "レート編集";
$l['button']['RemoveRate'] = "レート削除";

$l['button']['ListPlans'] = "プラン一覧";
$l['button']['NewPlan'] = "プラン新規作成";

$l['button']['EditPlan'] = "プラン編集";

$l['button']['RemovePlan'] = "プラン削除";


$l['button']['ListInvoices'] = "請求書一覧";
$l['button']['NewInvoice'] = "請求書新規作成";
$l['button']['EditInvoice'] = "請求書編集";
$l['button']['RemoveInvoice'] = "請求書削除";


$l['button']['ListRealms'] = "レルム一覧";
$l['button']['NewRealm'] = "レルム登録";
$l['button']['EditRealm'] = "レルム編集";
$l['button']['RemoveRealm'] = "レルム削除";
$l['button']['ListProxys'] = "プロキシ一覧";
$l['button']['NewProxy'] = "プロキシ登録";
$l['button']['EditProxy'] = "プロキシ編集";
$l['button']['RemoveProxy'] = "プロキシ削除";


$l['button']['ListAttributesforVendor'] = "ベンダ属性一覧:";

$l['button']['NewVendorAttribute'] = "ベンダ属性登録";

$l['button']['EditVendorAttribute'] = "ベンダ属性編集";
$l['button']['SearchVendorAttribute'] = "属性検索";
$l['button']['RemoveVendorAttribute'] = "ベンダ属性削除";
$l['button']['ImportVendorDictionary'] = "ベンダディレクトリインポート";

$l['button']['BetweenDates'] = "期間:";
$l['button']['Where'] = "検索条件";

$l['button']['AccountingFieldsinQuery'] = "クエリに指定するアカウンティング・フィールド:";
$l['button']['OrderBy'] = "並べ替え";
$l['button']['HotspotAccounting'] = "ホットスポットアカウンティング";
$l['button']['HotspotsComparison'] = "ホットスポット比較";

$l['button']['CleanupStaleSessions'] = "古いセッションのクリア";
$l['button']['DeleteAccountingRecords'] = "アカウンティングレコードの削除";

$l['button']['ListUsers'] = "ユーザ一覧";
$l['button']['ListBatches'] = "バッチ一覧";
$l['button']['RemoveBatch'] = "バッチ削除";
$l['button']['ImportUsers'] = "ユーザインポート";
$l['button']['NewUser'] = "ユーザ登録";
$l['button']['NewUserQuick'] = "ユーザ登録 - Quick追加";
$l['button']['BatchAddUsers'] = "バッチ・ユーザ登録";
$l['button']['EditUser'] = "ユーザ編集";
$l['button']['SearchUsers'] = "ユーザ検索";
$l['button']['RemoveUsers'] = "ユーザ削除";
$l['button']['ListHotspots'] = "ホットスポット一覧";
$l['button']['NewHotspot'] = "ホットスポット登録";
$l['button']['EditHotspot'] = "ホットスポット編集";
$l['button']['RemoveHotspot'] = "ホットスポット削除";

$l['button']['ListIPPools'] = "IPプール一覧";
$l['button']['NewIPPool'] = "IPプール登録";
$l['button']['EditIPPool'] = "IPプール編集";
$l['button']['RemoveIPPool'] = "IPプール削除";

$l['button']['ListNAS'] = "NAS一覧";
$l['button']['NewNAS'] = "NAS登録";
$l['button']['EditNAS'] = "NAS編集";
$l['button']['RemoveNAS'] = "NAS削除";
$l['button']['ListHG'] = "ハントグループ一覧";
$l['button']['NewHG'] = "ハントグループ登録";
$l['button']['EditHG'] = "ハントグループ編集";
$l['button']['RemoveHG'] = "ハントグループ削除";
$l['button']['ListUserGroup'] = "ユーザグループマッピング一覧";
$l['button']['ListUsersGroup'] = "ユーザのグループマッピング";
$l['button']['NewUserGroup'] = "ユーザグループマッピング登録";
$l['button']['EditUserGroup'] = "ユーザグループマッピング編集";
$l['button']['RemoveUserGroup'] = "ユーザグループマッピング削除";

$l['button']['ListProfiles'] = "プロファイル一覧";
$l['button']['NewProfile'] = "プロファイル登録";
$l['button']['EditProfile'] = "プロファイル編集";
$l['button']['DuplicateProfile'] = "プロファイル複製";
$l['button']['RemoveProfile'] = "プロファイル削除";


$l['button']['ListGroupReply'] = "グループリプライマッピング一覧";
$l['button']['SearchGroupReply'] = "グループリプライの検索";
$l['button']['NewGroupReply'] = "グループリプライマッピング登録";
$l['button']['EditGroupReply'] = "グループリプライマッピング編集";
$l['button']['RemoveGroupReply'] = "グループリプライマッピング削除";
$l['button']['ListGroupCheck'] = "グループチェックマッピング一覧";
$l['button']['SearchGroupCheck'] = "グループチェック検索";
$l['button']['NewGroupCheck'] = "グループチェックマッピング登録";
$l['button']['EditGroupCheck'] = "グループチェックマッピング編集";
$l['button']['RemoveGroupCheck'] = "グループチェックマッピング削除";


$l['button']['UserAccounting'] = "ユーザアカウンティング";
$l['button']['IPAccounting'] = "IP アカウンティング";
$l['button']['NASIPAccounting'] = "NAS IP アカウンティング";

$l['button']['NASIPAccountingOnlyActive'] = "アクティブなものだけ表示";

$l['button']['DateAccounting'] = "日付アカウンティング";
$l['button']['AllRecords'] = "全レコード";
$l['button']['ActiveRecords'] = "アクティブレコード";


$l['button']['PlanUsage'] = "プランの利用";

$l['button']['OnlineUsers'] = "オンラインユーザ";
$l['button']['LastConnectionAttempts'] = "最終接続";
$l['button']['TopUser'] = "トップユーザ";
$l['button']['History'] = "履歴";

$l['button']['ServerStatus'] = "サーバ状態";
$l['button']['ServicesStatus'] = "サービス状態";

$l['button']['daloRADIUSLog'] = "daloRADIUSログ";
$l['button']['RadiusLog'] = "RADIUSログ";
$l['button']['SystemLog'] = "システムログ";
$l['button']['BootLog'] = "起動ログ";

$l['button']['UserLogins'] = "ユーザログイン";
$l['button']['UserDownloads'] = "ユーザダウンロード";
$l['button']['UserUploads'] = "ユーザアップロード";
$l['button']['TotalLogins'] = "ログイン合計";
$l['button']['TotalTraffic'] = "通信量合計";
$l['button']['LoggedUsers'] = "ログインユーザ";

$l['button']['ViewMAP'] = "地図参照";
$l['button']['EditMAP'] = "地図編集";
$l['button']['RegisterGoogleMapsAPI'] = "GoogleMaps API 登録コード";

$l['button']['UserSettings'] = "ユーザ設定";
$l['button']['DatabaseSettings'] = "データベース設定";
$l['button']['LanguageSettings'] = "言語設定";
$l['button']['LoggingSettings'] = "ログ設定";
$l['button']['InterfaceSettings'] = "ウェブインタフェース設定";


$l['button']['ReAssignPlanProfiles'] = "プランプロファイルの再割り当て";

$l['button']['TestUserConnectivity'] = "ユーザ接続テスト";
$l['button']['DisconnectUser'] = "接続の切断";


$l['button']['ManageBackups'] = "バックアップの管理";
$l['button']['CreateBackups'] = "バックアップの作成";

$l['button']['ListOperators'] = "オペレータ一覧";
$l['button']['NewOperator'] = "オペレータ登録";
$l['button']['EditOperator'] = "オペレータ編集";
$l['button']['RemoveOperator'] = "オペレータ削除";


$l['button']['ProcessQuery'] = "クエリ実行";



/* ********************************************************************************** */


/* **********************************************************************************
* Titles
* The text related to all the title headers in captions,tables and tabbed layout text
************************************************************************************/

$l['title']['ImportUsers'] = "ユーザインポート";


$l['title']['Dashboard'] = "ダッシュボード";
$l['title']['DashboardAlerts'] = "アラート";

$l['title']['Invoice'] = "請求書";
$l['title']['Invoices'] = "請求書";
$l['title']['InvoiceRemoval'] = "請求書削除";

$l['title']['Payments'] = "支払い";

$l['title']['Items'] = "アイテム";

$l['title']['PayTypeInfo'] = "支払い方式情報";
$l['title']['PaymentInfo'] = "支払い情報";

$l['title']['RateInfo'] = "レート情報";

$l['title']['PlanInfo'] = "プラン情報";

$l['title']['TimeSettings'] = "時刻設定";
$l['title']['BandwidthSettings'] = "帯域幅の設定";

$l['title']['PlanRemoval'] = "プラン削除";

$l['title']['BatchRemoval'] = "バッチ削除";

$l['title']['Backups'] = "バックアップ";
$l['title']['FreeRADIUSTables'] = "FreeRADIUSテーブル";
$l['title']['daloRADIUSTables'] = "daloRADIUSテーブル";

$l['title']['IPPoolInfo'] = "IPプール情報";

$l['title']['BusinessInfo'] = "業務情報";

$l['title']['CleanupRecords'] = "レコードクリア";
$l['title']['DeleteRecords'] = "レコード削除";

$l['title']['RealmInfo'] = "レルム情報";

$l['title']['ProxyInfo'] = "プロキシ情報";

$l['title']['VendorAttribute'] = "ベンダ属性";

$l['title']['AccountRemoval'] = "アカウント削除";
$l['title']['AccountInfo'] = "アカウント情報";

$l['title']['Profiles'] = "プロファイル";
$l['title']['ProfileInfo'] = "プロファイル情報";

$l['title']['GroupInfo'] = "グループ情報";
$l['title']['GroupAttributes'] = "グループ属性";

$l['title']['NASInfo'] = "NAS情報";
$l['title']['NASAdvanced'] = "NAS高度情報";
$l['title']['HGInfo'] = "ハントグループ情報";
$l['title']['UserInfo'] = "ユーザ情報";
$l['title']['BillingInfo'] = "課金情報";

$l['title']['Attributes'] = "属性";
$l['title']['ProfileAttributes'] = "プロファイル属性";

$l['title']['HotspotInfo'] = "ホットスポット情報";
$l['title']['HotspotRemoval'] = "ホットスポット削除";

$l['title']['ContactInfo'] = "連絡先情報";

$l['title']['Plan'] = "プラン";

$l['title']['Profile'] = "プロファイル";
$l['title']['Groups'] = "グループ";
$l['title']['RADIUSCheck'] = "チェック属性";
$l['title']['RADIUSReply'] = "リプライ属性";

$l['title']['Settings'] = "設定";
$l['title']['DatabaseSettings'] = "データベース設定";
$l['title']['DatabaseTables'] = "データベーステーブル";
$l['title']['AdvancedSettings'] = "高度設定";

$l['title']['Advanced'] = "高度設定";
$l['title']['Optional'] = "オプション";

/* ********************************************************************************** */

/* **********************************************************************************
* Graphs 
* General graphing text
************************************************************************************/
$l['graphs']['Day'] = "日";
$l['graphs']['Month'] = "月";
$l['graphs']['Year'] = "年";
$l['graphs']['Jan'] = "1月";
$l['graphs']['Feb'] = "2月";
$l['graphs']['Mar'] = "3月";
$l['graphs']['Apr'] = "4月";
$l['graphs']['May'] = "5月";
$l['graphs']['Jun'] = "6月";
$l['graphs']['Jul'] = "7月";
$l['graphs']['Aug'] = "8月";
$l['graphs']['Sep'] = "9月";
$l['graphs']['Oct'] = "10月";
$l['graphs']['Nov'] = "11月";
$l['graphs']['Dec'] = "12月";


/* ********************************************************************************** */

/* **********************************************************************************
* Text
* General text information that is used through-out the pages
************************************************************************************/

$l['text']['LoginRequired'] = "ログイン認証";
$l['text']['LoginPlease'] = "ログインしてください";

/* ********************************************************************************** */



/* **********************************************************************************
* Contact Info 
* Related to all contact info text, user info, hotspot owner contact information etc
************************************************************************************/

$l['ContactInfo']['FirstName'] = "名";
$l['ContactInfo']['LastName'] = "姓";
$l['ContactInfo']['Email'] = "メールアドレス";
$l['ContactInfo']['Department'] = "部署";
$l['ContactInfo']['WorkPhone'] = "電話(会社)";
$l['ContactInfo']['HomePhone'] = "電話(自宅)";
$l['ContactInfo']['Phone'] = "電話";
$l['ContactInfo']['MobilePhone'] = "携帯電話";
$l['ContactInfo']['Notes'] = "備考";
$l['ContactInfo']['EnableUserUpdate'] = "ユーザ更新";
$l['ContactInfo']['EnablePortalLogin'] = "ポータルログイン";
$l['ContactInfo']['PortalLoginPassword'] = "ポータルログインパスワード";

$l['ContactInfo']['OwnerName'] = "オーナー名";

$l['ContactInfo']['OwnerEmail'] = "オーナーEメール";

$l['ContactInfo']['ManagerName'] = "管理者名";
$l['ContactInfo']['ManagerEmail'] = "管理者Eメール";
$l['ContactInfo']['Company'] = "会社";
$l['ContactInfo']['Address'] = "住所";
$l['ContactInfo']['City'] = "市";
$l['ContactInfo']['State'] = "県";
$l['ContactInfo']['Country'] = "国";
$l['ContactInfo']['Zip'] = "郵便番号";
$l['ContactInfo']['Phone1'] = "電話番号 1";
$l['ContactInfo']['Phone2'] = "電話番号 2";
$l['ContactInfo']['HotspotType'] = "ホットスポットタイプ";
$l['ContactInfo']['CompanyWebsite'] = "会社ウェブサイト";
$l['ContactInfo']['CompanyPhone'] = "会社電話番号";
$l['ContactInfo']['CompanyEmail'] = "会社Eメール";
$l['ContactInfo']['CompanyContact'] = "会社連絡先";

$l['ContactInfo']['PlanName'] = "プラン名";
$l['ContactInfo']['ContactPerson'] = "連絡先担当者";
$l['ContactInfo']['PaymentMethod'] = "支払い方法";
$l['ContactInfo']['Cash'] = "現金";
$l['ContactInfo']['CreditCardNumber'] = "クレジットカード番号";
$l['ContactInfo']['CreditCardName'] = "クレジットカード名";
$l['ContactInfo']['CreditCardVerificationNumber'] = "クレジットカード認証番号";
$l['ContactInfo']['CreditCardType'] = "クレジットカードタイプ";
$l['ContactInfo']['CreditCardExpiration'] = "クレジットカード有効期限";

/* ********************************************************************************** */

$l['Intro']['configdashboard.php'] = "ダッシュボード設定";

$l['Intro']['paymenttypesmain.php'] = "支払い方式ページ";
$l['Intro']['paymenttypesdel.php'] = "支払い方式のエントリ削除";
$l['Intro']['paymenttypesedit.php'] = "支払い方式詳細の編集";
$l['Intro']['paymenttypeslist.php'] = "支払い方式一覧表";
$l['Intro']['paymenttypesnew.php'] = "新しい支払い方式のエントリ";
$l['Intro']['paymentslist.php'] = "支払い一覧表";
$l['Intro']['paymentsmain.php'] = "支払いページ";
$l['Intro']['paymentsdel.php'] = "支払いエントリの削除";
$l['Intro']['paymentsedit.php'] = "支払い詳細の編集";
$l['Intro']['paymentsnew.php'] = "支払いエントリ新規作成";

$l['Intro']['billhistorymain.php'] = "課金履歴";
$l['Intro']['msgerrorpermissions.php'] = "エラー";

$l['Intro']['repnewusers.php'] = "新規ユーザ一覧";

$l['Intro']['mngradproxys.php'] = "プロキシ管理";
$l['Intro']['mngradproxysnew.php'] = "プロキシ登録";
$l['Intro']['mngradproxyslist.php'] = "プロキシ一覧";
$l['Intro']['mngradproxysedit.php'] = "プロキシ編集";
$l['Intro']['mngradproxysdel.php'] = "プロキシ削除";

$l['Intro']['mngradrealms.php'] = "レルム管理";
$l['Intro']['mngradrealmsnew.php'] = "レルム登録";
$l['Intro']['mngradrealmslist.php'] = "レルム一覧";
$l['Intro']['mngradrealmsedit.php'] = "レルム編集";
$l['Intro']['mngradrealmsdel.php'] = "レルム削除";

$l['Intro']['mngradattributes.php'] = "ベンダ属性管理";
$l['Intro']['mngradattributeslist.php'] = "ベンダ属性一覧";
$l['Intro']['mngradattributesnew.php'] = "ベンダ属性登録";
$l['Intro']['mngradattributesedit.php'] = "ベンダ属性編集";
$l['Intro']['mngradattributessearch.php'] = "属性検索";
$l['Intro']['mngradattributesdel.php'] = "ベンダ属性削除";
$l['Intro']['mngradattributesimport.php'] = "ベンダディレクトリインポート";
$l['Intro']['mngimportusers.php'] = "ユーザインポート";


$l['Intro']['acctactive.php'] = "アクティブレコードアカウンティング";
$l['Intro']['acctall.php'] = "全ユーザアカウンティング";
$l['Intro']['acctdate.php'] = "日付順アカウンティング";
$l['Intro']['accthotspot.php'] = "ホットスポットアカウンティング";
$l['Intro']['acctipaddress.php'] = "IPアカウンティング";

$l['Intro']['accthotspotcompare.php'] = "ホットスポット比較";
$l['Intro']['acctmain.php'] = "アカウンティングページ";
$l['Intro']['acctplans.php'] = "プランアカウンティングページ";
$l['Intro']['acctnasipaddress.php'] = "NAS IPアカウンティング";
$l['Intro']['acctusername.php'] = "ユーザアカウンティング";
$l['Intro']['acctcustom.php'] = "カスタムアカウンティング";
$l['Intro']['acctcustomquery.php'] = "カスタムクエリ・アカウンティング";
$l['Intro']['acctmaintenance.php'] = "アカウンティングレコード管理";
$l['Intro']['acctmaintenancecleanup.php'] = "古いセッションのクリア";
$l['Intro']['acctmaintenancedelete.php'] = "アカウンティングレコードの削除";

$l['Intro']['billmain.php'] = "課金ページ";
$l['Intro']['ratesmain.php'] = "レート課金ページ";

$l['Intro']['billratesdate.php'] = "レートプリペイドアカウンティング";
$l['Intro']['billratesdel.php'] = "レートエントリを削除";
$l['Intro']['billratesedit.php'] = "レート詳細を編集";
$l['Intro']['billrateslist.php'] = "レート一覧表";
$l['Intro']['billratesnew.php'] = "レートエントリ新規作成";

$l['Intro']['paypalmain.php'] = "PayPal取引ページ";
$l['Intro']['billpaypaltransactions.php'] = "PayPal取引ページ";

$l['Intro']['billhistoryquery.php'] = "課金履歴";

$l['Intro']['billinvoice.php'] = "支払い請求書";
$l['Intro']['billinvoicedel.php'] = "請求書エントリの削除";

$l['Intro']['billinvoiceedit.php'] = "請求書編集";

$l['Intro']['billinvoicelist.php'] = "請求書一覧";

$l['Intro']['billinvoicereport.php'] = "請求書レポート";

$l['Intro']['billinvoicenew.php'] = "新しい請求書";

$l['Intro']['billplans.php'] = "課金プランページ";
$l['Intro']['billplansdel.php'] = "プランエントリの削除";

$l['Intro']['billplansedit.php'] = "プラン詳細の編集";

$l['Intro']['billplanslist.php'] = "プラン一覧表";

$l['Intro']['billplansnew.php'] = "新しいプランエントリ";

$l['Intro']['billpos.php'] = "課金POS(Point Of Sales)ページ";

$l['Intro']['billposdel.php'] = "ユーザの削除";

$l['Intro']['billposedit.php'] = "ユーザの編集";

$l['Intro']['billposlist.php'] = "ユーザの一覧";
$l['Intro']['billposnew.php'] = "ユーザ登録";

$l['Intro']['giseditmap.php'] = "地図編集モード";

$l['Intro']['gismain.php'] = "GISマッピング";

$l['Intro']['gisviewmap.php'] = "地図参照モード";

$l['Intro']['graphmain.php'] = "グラフの使用方法";

$l['Intro']['graphsalltimetrafficcompare.php'] = "合計トラフィック利用状況の比較";

$l['Intro']['graphsalltimelogins.php'] = "ログイン合計";
$l['Intro']['graphsloggedusers.php'] = "ユーザログイン";
$l['Intro']['graphsoveralldownload.php'] = "ユーザダウンロード";
$l['Intro']['graphsoveralllogins.php'] = "ユーザログイン";
$l['Intro']['graphsoverallupload.php'] = "ユーザアップロード";

$l['Intro']['rephistory.php'] = "アクション履歴";

$l['Intro']['replastconnect.php'] = "最終接続";

$l['Intro']['repstatradius.php'] = "デーモン情報";
$l['Intro']['repstatserver.php'] = "サーバ状態と情報";

$l['Intro']['reponline.php'] = "オンラインユーザの一覧";
$l['Intro']['replogssystem.php'] = "システムログ";
$l['Intro']['replogsradius.php'] = "RADIUSサーバログ";
$l['Intro']['replogsdaloradius.php'] = "daloRADIUSログ";
$l['Intro']['replogsboot.php'] = "起動ログ";
$l['Intro']['replogs.php'] = "ログ";
$l['Intro']['rephb.php'] = "Heartbeat";
$l['Intro']['rephbdashboard.php'] = "daloRADIUS NAS ダッシュボード";
$l['Intro']['repbatch.php'] = "バッチ";
$l['Intro']['mngbatchlist.php'] = "バッチセッション一覧";
$l['Intro']['repbatchlist.php'] = "バッチユーザ一覧";
$l['Intro']['repbatchdetails.php'] = "バッチ詳細";

$l['Intro']['rephsall.php'] = "ホットスポット一覧";
$l['Intro']['repmain.php'] = "レポートページ";
$l['Intro']['repstatus.php'] = "状態ページ";
$l['Intro']['reptopusers.php'] = "トップユーザ";
$l['Intro']['repusername.php'] = "ユーザ一覧";

$l['Intro']['mngbatch.php'] = "バッチユーザ作成";
$l['Intro']['mngbatchdel.php'] = "バッチセッション削除";

$l['Intro']['mngdel.php'] = "ユーザ削除";
$l['Intro']['mngedit.php'] = "ユーザ詳細編集";
$l['Intro']['mnglistall.php'] = "ユーザ一覧";
$l['Intro']['mngmain.php'] = "ユーザ・ホットスポット管理";
$l['Intro']['mngbatch.php'] = "バッチユーザ管理";
$l['Intro']['mngnew.php'] = "ユーザ登録";
$l['Intro']['mngnewquick.php'] = "ユーザ登録 - Quick追加";
$l['Intro']['mngsearch.php'] = "ユーザ検索";

$l['Intro']['mnghsdel.php'] = "ホットスポット削除";
$l['Intro']['mnghsedit.php'] = "ホットスポット詳細編集";
$l['Intro']['mnghslist.php'] = "ホットスポット一覧";
$l['Intro']['mnghsnew.php'] = "ホットスポット登録";

$l['Intro']['mngradusergroupdel.php'] = "ユーザグループマッピング削除";
$l['Intro']['mngradusergroup.php'] = "ユーザグループ設定";
$l['Intro']['mngradusergroupnew.php'] = "ユーザグループマッピング登録";

$l['Intro']['mngradusergrouplist'] = "データベースのユーザグループマッピング";

$l['Intro']['mngradusergrouplistuser'] = "データベースのユーザグループマッピング";

$l['Intro']['mngradusergroupedit'] = "ユーザのユーザグループマッピングを編集:";

$l['Intro']['mngradippool.php'] = "IPプール設定";
$l['Intro']['mngradippoolnew.php'] = "IPプール登録";
$l['Intro']['mngradippoollist.php'] = "IPプール一覧";
$l['Intro']['mngradippooledit.php'] = "IPプール編集";
$l['Intro']['mngradippooldel.php'] = "IPプール削除";

$l['Intro']['mngradnas.php'] = "NAS設定";

$l['Intro']['mngradnasnew.php'] = "新しいNASレコード";

$l['Intro']['mngradnaslist.php'] = "データベースのNAS一覧";

$l['Intro']['mngradnasedit.php'] = "NASレコード編集";

$l['Intro']['mngradnasdel.php'] = "NASレコード削除";

$l['Intro']['mngradhunt.php'] = "ハントグループ設定";

$l['Intro']['mngradhuntnew.php'] = "新しいハントグループレコード";

$l['Intro']['mngradhuntlist.php'] = "ハントグループ一覧";

$l['Intro']['mngradhuntedit.php'] = "ハントグループレコードの編集";

$l['Intro']['mngradhuntdel.php'] = "ハントグループレコードの削除";

$l['Intro']['mngradprofiles.php'] = "プロファイル設定";
$l['Intro']['mngradprofilesedit.php'] = "プロファイル編集";
$l['Intro']['mngradprofilesduplicate.php'] = "プロファイル複製";
$l['Intro']['mngradprofilesdel.php'] = "プロファイル削除";
$l['Intro']['mngradprofileslist.php'] = "プロファイル一覧";
$l['Intro']['mngradprofilesnew.php'] = "プロファイル登録";

$l['Intro']['mngradgroups.php'] = "グループ設定";

$l['Intro']['mngradgroupreplynew.php'] = "新しいグループリプライマッピング";

$l['Intro']['mngradgroupreplylist.php'] = "データベースのグループリプライマッピング";

$l['Intro']['mngradgroupreplyedit.php'] = "グループのグループリプライマッピングの編集:";

$l['Intro']['mngradgroupreplydel.php'] = "グループリプライマッピングの削除";

$l['Intro']['mngradgroupreplysearch.php'] = "グループリプライマッピングの検索";

$l['Intro']['mngradgroupchecknew.php'] = "新しいグループチェックマッピング";

$l['Intro']['mngradgroupchecklist.php'] = "データベースのグループチェックマッピング";

$l['Intro']['mngradgroupcheckedit.php'] = "グループのグループチェックマッピング:";

$l['Intro']['mngradgroupcheckdel.php'] = "グループチェックマッピングの削除";

$l['Intro']['mngradgroupchecksearch.php'] = "グループチェックマッピングの検索";

$l['Intro']['configuser.php'] = "ユーザ設定";
$l['Intro']['configmail.php'] = "メール設定";

$l['Intro']['configdb.php'] = "データベース設定";
$l['Intro']['configlang.php'] = "言語設定";
$l['Intro']['configlogging.php'] = "ログ設定";
$l['Intro']['configinterface.php'] = "ウェブインタフェース設定";
$l['Intro']['configmainttestuser.php'] = "ユーザ接続テスト";
$l['Intro']['configmain.php'] = "データベース設定";
$l['Intro']['configmaint.php'] = "メンテナンス";
$l['Intro']['configmaintdisconnectuser.php'] = "接続の切断";

$l['Intro']['configbusiness.php'] = "業務詳細";

$l['Intro']['configbusinessinfo.php'] = "業務情報";

$l['Intro']['configbackup.php'] = "バックアップ";

$l['Intro']['configbackupcreatebackups.php'] = "バックアップ作成";

$l['Intro']['configbackupmanagebackups.php'] = "バックアップ管理";

$l['Intro']['configoperators.php'] = "オペレータ設定";
$l['Intro']['configoperatorsdel.php'] = "オペレータ削除";
$l['Intro']['configoperatorsedit.php'] = "オペレータ編集";
$l['Intro']['configoperatorsnew.php'] = "オペレータ登録";
$l['Intro']['configoperatorslist.php'] = "オペレータ一覧";

$l['Intro']['login.php'] = "Login";

$l['captions']['providebillratetodel'] = "削除したいレートエントリタイプを入力してください";
$l['captions']['detailsofnewrate'] = "新しいレートの詳細を記入することができます";
$l['captions']['filldetailsofnewrate'] = "新しいレートエントリの詳細を記入してください";

/************************************************************************************
* Help Pages Info 
* Each page has a header which is the Intro class, when clicking on the header
* it will reveal/hide a helpPage div content which is a description of a specific
* page, basically your expanded tool-tip.
************************************************************************************/

$l['helpPage']['configdashboard'] = "ダッシュボード設定";

$l['helpPage']['repnewusers'] = "以下の表は月ごとに新しく作成されたユーザを表示します";

$l['helpPage']['login'] = "";

$l['helpPage']['billpaypaltransactions'] = "全てのPayPal取引を一覧表示します";
$l['helpPage']['billhistoryquery'] = "ユーザの全ての課金履歴を一覧表示します";

$l['helpPage']['billinvoicereport'] = "";

$l['helpPage']['billinvoicelist'] = "";
$l['helpPage']['billinvoicenew'] = "";
$l['helpPage']['billinvoiceedit'] = "";
$l['helpPage']['billinvoicedel'] = "";

$l['helpPage']['paymenttypeslist'] = "";
$l['helpPage']['paymenttypesnew'] = "";
$l['helpPage']['paymenttypesedit'] = "";
$l['helpPage']['paymenttypesdel'] = "";
$l['helpPage']['paymenttypesdate'] = "";

$l['helpPage']['paymentslist'] = "";
$l['helpPage']['paymentsnew'] = "";
$l['helpPage']['paymentsedit'] = "";
$l['helpPage']['paymentsdel'] = "";
$l['helpPage']['paymentsdate'] = "";

$l['helpPage']['billplanslist'] = "";
$l['helpPage']['billplansnew'] = "";
$l['helpPage']['billplansedit'] = "";
$l['helpPage']['billplansdel'] = "";

$l['helpPage']['billposlist'] = "";
$l['helpPage']['billposnew'] = "";
$l['helpPage']['billposedit'] = "";
$l['helpPage']['billposdel'] = "";

$l['helpPage']['billrateslist'] = "";
$l['helpPage']['billratesnew'] = "";

$l['helpPage']['billratesedit'] = "";
$l['helpPage']['billratesdel'] = "";
$l['helpPage']['billratesdate'] = "";

$l['helpPage']['mngradproxys'] = "";
$l['helpPage']['mngradproxyslist'] = "";
$l['helpPage']['mngradproxysnew'] = "";
$l['helpPage']['mngradproxysedit'] = "";
$l['helpPage']['mngradproxysdel'] = "";

$l['helpPage']['mngradrealms'] = "";
$l['helpPage']['mngradrealmslist'] = "";
$l['helpPage']['mngradrealmsnew'] = "";
$l['helpPage']['mngradrealmsedit'] = "";
$l['helpPage']['mngradrealmsdel'] = "";

$l['helpPage']['mngradattributes'] = "";
$l['helpPage']['mngradattributeslist'] = "";
$l['helpPage']['mngradattributesnew'] = "";
$l['helpPage']['mngradattributesedit'] = "";
$l['helpPage']['mngradattributessearch'] = "";
$l['helpPage']['mngradattributesdel'] = "";
$l['helpPage']['mngradattributesimport'] = "";
$l['helpPage']['mngimportusers'] = "";

$l['helpPage']['msgerrorpermissions'] = "ページにアクセスする権限がありません。 <br/>
システム管理者に問い合わせてください <br/>";

$l['helpPage']['mngradusergroup'] = "";

$l['helpPage']['mngradusergroupdel'] = "ユーザエントリをデータベースから削除するには、アカウントのユーザ名を指定しなければなりません";
$l['helpPage']['mngradusergroupnew'] = "";
$l['helpPage']['mngradusergrouplist'] = "";
$l['helpPage']['mngradusergrouplistuser'] = "";
$l['helpPage']['mngradusergroupedit'] = "";


$l['helpPage']['mngradprofiles'] = "
<b>プロファイル管理</b> - Reply属性とCheck属性の両方を組み合わせることで、ユーザのプロファイルを管理します。 <br/>
プロファイルはグループリプライとグループチェックで構成されると思われます。 <br/>
<h200><b>プロファイル一覧 </b></h200> - プロファイルを一覧表示する <br/>
<h200><b>プロファイル登録 </b></h200> - プロファイルを追加する <br/>
<h200><b>プロファイル編集 </b></h200> - プロファイルを編集する <br/>
<h200><b>プロファイル削除 </b></h200> - プロファイルを削除する <br/>
";


$l['helpPage']['mngradprofilesedit'] = "
<h200><b>プロファイル編集 </b></h200> - プロファイルを編集します <br/>
";

$l['helpPage']['mngradprofilesdel'] = "
<h200><b>プロファイル削除 </b></h200> - プロファイルを削除します <br/>
";

$l['helpPage']['mngradprofilesduplicate'] = "
<h200><b>プロファイル複製 </b></h200> - プロファイルの属性の組み合わせを別名の新しいプロファイルに複製します <br/>
";

$l['helpPage']['mngradprofileslist'] = "
<h200><b>プロファイル一覧 </b></h200> - プロファイルを一覧表示します <br/>
";

$l['helpPage']['mngradprofilesnew'] = "
<h200><b>プロファイル登録 </b></h200> - プロファイルを追加します <br/>
";

$l['helpPage']['mngradgroups'] = "
<b>グループ管理</b> - グループリプライ、グループチェックのマッピング (RADIUSグループリプライ/RADIUSグループチェック テーブル)を管理します。<br/>
<h200><b>グループ リプライ/チェック 一覧</b></h200> - グループ リプライ/チェック マッピングを一覧表示します<br/>
<h200><b>グループ リプライ/チェック 検索</b></h200> - グループ リプライ/チェック
マッピングを検索します(ワイルドカード使用可能) <br/>
<h200><b>グループ リプライ/チェック 登録</b></h200> - グループ リプライ/チェック マッピングを追加します <br/>
<h200><b>グループ リプライ/チェック 編集</b></h200> - グループ リプライ/チェック マッピングを編集します <br/>
<h200><b>グループ リプライ/チェック 削除</b></h200> - グループ リプライ/チェック マッピングを削除します <br/>
";


$l['helpPage']['mngradgroupchecknew'] = "
<h200><b>グループチェック登録 </b></h200> - グループチェックマッピングを追加します<br/>
";

$l['helpPage']['mngradgroupcheckdel'] = "
<h200><b>グループチェック削除</b></h200> - グループチェックマッピングを削除します<br/>
";

$l['helpPage']['mngradgroupchecklist'] = "
<h200><b>グループチェック一覧</b></h200> - グループチェックマッピングを一覧表示します<br/>
";

$l['helpPage']['mngradgroupcheckedit'] = "
<h200><b>グループチェック編集</b></h200> - グループチェックマッピングを編集します <br/>
";

$l['helpPage']['mngradgroupchecksearch'] = "
<h200><b>グループチェック検索</b></h200> - グループチェックマッピングを検索します <br/>
ワイルドカードには、「%」または「*」文字が利用可能です。 「%」はSQLとしてよく知られたワイルドカードです。「*」はより広く知られたワイルドカードで、daloRADIUSはこれを「%」に置換します。
";

$l['helpPage']['mngradgroupreplynew'] = "
<h200><b>グループリプライ登録</b></h200> - グループリプライマッピングを追加します <br/>
";

$l['helpPage']['mngradgroupreplydel'] = "
<h200><b>グループリプライ削除</b></h200> - グループリプライマッピングを削除します<br/>
";

$l['helpPage']['mngradgroupreplylist'] = "
<h200><b>グループリプライ一覧</b></h200> - グループリプライマッピングを一覧表示します<br/>
";

$l['helpPage']['mngradgroupreplyedit'] = "
<h200><b>グループリプライ編集</b></h200> - グループリプライマッピングを編集します<br/>
";

$l['helpPage']['mngradgroupreplysearch'] = "
<h200><b>グループリプライ検索</b></h200> - グループリプライマッピングを検索します<br/>
ワイルドカードには、「%」または「*」文字が利用可能です。 「%」はSQLとしてよく知られたワイルドカードです。「*」はより広く知られたワイルドカードで、daloRADIUSはこれを「%」に置換します。
";


$l['helpPage']['mngradippool'] = "
<h200><b>IPプール一覧</b></h200> - 設定されたIPプールとそれらに割当てられたIPアドレスを一覧表示します<br/>
<h200><b>IPプール登録</b></h200> - 設定されたIPプールに新しいIPアドレスを追加します<br/>
<h200><b>IPプール編集</b></h200> - 設定されたIPプールのIPアドレスを編集します<br/>
<h200><b>IPプール削除</b></h200> - 設定されたIPプールからIPアドレスを削除します<br/>
";

$l['helpPage']['mngradippoollist'] = "<h200><b>IPプール一覧</b></h200> - 設定されたIPプールとそれらに割当てられたIPアドレスを一覧表示します<br/>";

$l['helpPage']['mngradippoolnew'] = "<h200><b>IPプール登録</b></h200> - 設定されたIPプールに新しいIPアドレスを追加します<br/>";

$l['helpPage']['mngradippooledit'] = "<h200><b>IPプール編集</b></h200> - 設定されたIPプールのIPアドレスを編集します<br/>";

$l['helpPage']['mngradippooldel'] = "<h200><b>IPプール削除</b></h200> - 設定されたIPプールからIPアドレスを削除します<br/>";


$l['helpPage']['mngradnas'] = "";

$l['helpPage']['mngradnasdel'] = "データベスからNASの IP/ホスト エントリを削除するには、アカウントの IP/ホスト を入力しなければなりません";

$l['helpPage']['mngradnasnew'] = "";
$l['helpPage']['mngradnaslist'] = "";
$l['helpPage']['mngradnasedit'] = "";



$l['helpPage']['mngradhunt'] = "ハントグループとの連携を開始する前に、 <a href='http://wiki.freeradius.org/SQL_Huntgroup_HOWTO' target='_blank'>http://wiki.freeradius.org/SQL_Huntgroup_HOWTO</a> を読んでください。
<br/>
特に、:
...
<i>Locate the authorize section in your radiusd.conf or sites-enabled/defaut configuration file and edit it. At the top of the authorize section after the preprocess module insert these lines:</i>
<br/>
<pre>
update request {
Huntgroup-Name := \"%{sql:select groupname from radhuntgroup where nasipaddress=\"%{NAS-IP-Address}\"}\"
}
</pre>
<i> What this does is perform a lookup in the radhuntgroup table using the ip-address as a key to return the huntgroup name. It then adds an attribute/value pair to the request where the name of the attribute is Huntgroup-Name and it's value is whatever was returned from the SQL query. If the query did not find anything then the value is the empty string. </i>";


$l['helpPage']['mngradhuntdel'] = "データベスからハントグループエントリを削除するには、ハントグループの IP/ホスト とポートIDを入力しなければなりません";
$l['helpPage']['mngradhuntnew'] = "";
$l['helpPage']['mngradhuntlist'] = "";
$l['helpPage']['mngradhuntedit'] = "";

$l['helpPage']['mnghsdel'] = "データベースからホットスポットを削除するには、ホットスポットの名前を入力しなければなりません<br/>";

$l['helpPage']['mnghsedit'] = "以下のホットスポットの詳細を編集できます<br/>";

$l['helpPage']['mnghsnew'] = "以下ではデータベースに追加する新しいホットスポットの詳細を入力できます";

$l['helpPage']['mnghslist'] = "データベースの全てのホットスポットを一覧表示します。 データベースからホットスポットを編集、削除するためにクイックリンクを使うことができます。";

$l['helpPage']['configdb'] = "
<b>データベース設定</b> - データベースエンジン、接続設定、テーブル名がデフォルトでない時の設定や、データベースのパスワード暗号化方式の設定を行います。
<br/>
<h200><b>グローバル設定</b></h200> - データベースストレージエンジン<br/>
<h200><b>テーブル設定</b></h200> - FreeRADIUS スキーマのデフォルトを使用しないときにテーブル名を変更できます。<br/>
<h200><b>高度な設定</b></h200> - パスワードをプレーンテキストでなく何らかの暗号化を行ってデータベースに保存したい場合、MD5 または Crypt が選択できます<br/>
";

$l['helpPage']['configlang'] = "
<h200><b>言語設定</b></h200> - インターフェース言語を設定します<br/>
";

$l['helpPage']['configuser'] = "
<h200><b>ユーザ設定</b></h200> - ユーザ管理の動作を設定します<br/>
";

$l['helpPage']['configmail'] = "
<h200><b>メール設定</b></h200> - メールの設定を行います<br/>
";

$l['helpPage']['configlogging'] = "
<h200><b>ロギング設定</b></h200> - ロギングのルールとファシリティを設定します。<br/>
指定するファイル名にはウェブサーバからの書き込み権があることを確認してください<br/>";

$l['helpPage']['configinterface'] = "
<h200><b>インターフェース設定</b></h200> - インターフェースのレイアウト設定と動作を設定します <br/>
";

$l['helpPage']['configmain'] = "
<b>グローバル設定</b><br/>
<h200><b>データベース設定</b></h200> - データベースエンジン、接続設定、テーブル名がデフォルトでない時の設定や、データベースのパスワード暗号化方式の設定を行います。<br/>
<h200><b>言語設定</b></h200> - インターフェース言語を設定します<br/>
<h200><b>ロギング設定</b></h200> - ロギングのルールとファシリティを設定します<br/>
<h200><b>インターフェース設定</b></h200> - インターフェースのレイアウト設定と動作を設定します<br/>

<b>設定ページの下位カテゴリ</b><br/>
<h200><b>メンテナンス</b></h200> - ユーザの接続とセッション終了をテストするためのメンテナンスオプション<br/>
<h200><b>オペレーション</b></h200> - オペレータの Access Control List (ACL) を設定します<br/>
";

$l['helpPage']['configbusiness'] = "
<b>業務情報</b><br/>
<h200><b>業務問い合わせ</b></h200> - 業務問い合わせ情報を設定します (オーナー, 肩書, 住所, 電話番号, など)<br/>
";

$l['helpPage']['configbusinessinfo'] = "";

$l['helpPage']['configmaint'] = "
<b>メンテナンス</b><br/>
<h200><b>ユーザの接続テスト</b></h200> - RADIUS サーバにアクセスリクエストを送り、ユーザの証明書が有効であるかどうかをチェックします<br/>
<h200><b>ユーザの切断</b></h200> - NASサーバに PoD (Packet of Disconnect) または CoA (Change of Authority) パケットを送信し、
ユーザの接続を切ってセッションを終了させます。<br/>
";

$l['helpPage']['configmainttestuser'] = "
<h200><b>ユーザの接続テスト</b></h200> - RADIUS サーバにアクセスリクエストを送り、ユーザの証明書が有効であるかどうかをチェックします<br/>
daloRADIUS は radclient バイナリユーティリティを利用してテストを実行し、それが終わるとそのコマンドの結果を返します。<br/>
daloRADIUS はあなたの\$PATH環境変数に radclient バイナリが利用できることを期待します。そうでない場合、library/exten-maint-radclient.php ファイルを修正してください。<br/><br/>

接続失敗や radclient のパケット再転送が起こるため、テストが完了するまでにはしばらく時間がかかる (10-20 秒程度まで) ことに注意してください。

高度設定タブではテストのためのオプションを微調整することができます:<br/>
タイムアウト - リトライを行うまでに、指定した秒数だけ待ちます (浮動小数点数で指定できます) <br/>
リトライ - タイムアウトした場合、指定回数だけリトライを行います <br/>
カウント - それぞれのパケットを 指定回数ずつ送信します <br/>
リクエスト - ひとつのファイルから指定した数のパケットを並列で送信します <br/>
";

$l['helpPage']['configmaintdisconnectuser'] = "
<h200><b>ユーザの切断</b></h200> - NASサーバに PoD (Packet of Disconnect) または CoA (Change of Authority) パケットを送信し、
ユーザの接続を切ってセッションを終了させます。<br/>
ユーザのセッションを終了するために、NAS が PoD または CoA パケットタイプをサポートしている必要があるため、NASベンダーに問い合わせるか
あなたのNASの文書を調べてください。
さらに、PoD または CoA パケットの NAS ポートを知る必要があります。新しい NAS はポート 3799 を使うのに対して、他のものはパケットをポート 1700 で受け取るように設定されています。
<br/><br/>

daloRADIUS は radclient バイナリユーティリティを利用してテストを実行し、それが終わるとそのコマンドの結果を返します。<br/>
daloRADIUS はあなたの\$PATH環境変数に radclient バイナリが利用できることを期待します。そうでない場合、library/exten-maint-radclient.php ファイルを修正
してください。<br/><br/>

接続失敗や radclient のパケット再転送が起こるため、テストが完了するまでにはしばらく時間がかかる (10-20 秒程度まで) ことに注意してください。

高度設定タブではテストのためのオプションを微調整することができます:<br/>
タイムアウト - リトライを行うまでに、指定した秒数だけ待ちます (浮動小数点数で指定できます) <br/>
リトライ - タイムアウトした場合、指定回数だけリトライを行います <br/>
カウント - それぞれのパケットを 指定回数ずつ送信します <br/>
リクエスト - ひとつのファイルから指定した数のパケットを並列で送信します <br/>
";

$l['helpPage']['configoperatorsdel'] = "データベースからオペレータを削除するには、ユーザ名を指定しなければなりません";

$l['helpPage']['configoperatorsedit'] = "以下のオペレータユーザの詳細を編集します";

$l['helpPage']['configoperatorsnew'] = "データベースに登録する新しいオペレータの詳細を記入できます";

$l['helpPage']['configoperatorslist'] = "データベースの全てのオペレータを一覧表示します";

$l['helpPage']['configoperators'] = "オペレータ設定";

$l['helpPage']['configbackup'] = "バックアップ実行";

$l['helpPage']['configbackupcreatebackups'] = "バックアップ作成";

$l['helpPage']['configbackupmanagebackups'] = "バックアップ管理";


$l['helpPage']['graphmain'] = "
<b>グラフ</b><br/>
<h200><b>全体 ログイン数/ヒット数</b></h200> - 指定期間（年、月、日）あたりの特定ユーザの利用状況を示す図表。
ログイン数 (または NAS へのヒット数) をグラフと表で示します。<br/>
<h200><b>全体ダウンロード統計</b></h200> - 指定期間（年、月、日）あたりの特定ユーザの利用状況を示す図表。
クライアントからのデータダウンロード数は計算された値。グラフと表で示します。<br/>
<h200><b>全体アップロード統計</b></h200> - 指定期間（年、月、日）あたりの特定ユーザの利用状況を示す図表。
クライアントからのデータアップロード数は計算された値。グラフと表で示します。<br/>
<br/>
<h200><b>通算 ログイン数/ヒット数 統計</b></h200> - 指定期間（年、月、日）あたりのサーバへのログイン数をグラフと表で示します。<br/>
<h200><b>通算通信量統計</b></h200> - ダウンロード及びアップロードの統計をグラフと表で示します。</br>
<h200><b>ログインユーザ</b></h200> - 指定期間（年、月、日）にログインしたユーザを示す図表。</br>
日、月、年でフィルターを行って時間ごとのグラフを作成するか、月、年だけでフィルターを行って (日フィールドで \"---\" を選択する) 、選択月の最小・最大ログインユーザのグラフを作成します";

$l['helpPage']['graphsalltimelogins'] = "指定期間の分布をもとにしたサーバログインの通算統計";

$l['helpPage']['graphsalltimetrafficcompare'] = "指定期間の分布を元にしたサーバ通信量の通算統計";

$l['helpPage']['graphsloggedusers'] = "総ログインユーザの図表";

$l['helpPage']['graphsoveralldownload'] = "サーバへのダウンロード要求のバイト数の図表";

$l['helpPage']['graphsoverallupload'] = "サーバへのアップロード要求のバイト数の図表";

$l['helpPage']['graphsoveralllogins'] = "サーバーへのログイン要求の図表";



$l['helpPage']['rephistory'] = "アイテムでは実施された全てのアクティビティを表示し、その登録日、登録者、更新日、更新者の情報を一覧表示します<br/>
";

$l['helpPage']['replastconnect'] = "RADIUSサーバーへの全てのログイン要求と、成功、失敗の履歴を一覧表示します";

$l['helpPage']['replogsboot'] = "オペレーティングシステムの起動ログをモニタリングします。dmesg コマンドを実行した結果と同じです";

$l['helpPage']['replogsdaloradius'] = "daloRADIUS のログファイルをモニタリングします";

$l['helpPage']['replogsradius'] = "FreeRADIUS のログファイルをモニタリングします";

$l['helpPage']['replogssystem'] = "オペレーティングシステムのログファイルをモニタリングします";
$l['helpPage']['rephb'] = "";
$l['helpPage']['rephbdashboard'] = "";
$l['helpPage']['repbatch'] = "";
$l['helpPage']['repbatchlist'] = "";
$l['helpPage']['mngbatchlist'] = "";
$l['helpPage']['mngbatchdel'] = "";

$l['helpPage']['repbatchdetails'] = "アクティブユーザのバッチインスタンスの一覧を表示します";

$l['helpPage']['replogs'] = "
<b>ログ</b><br/>
<h200><b>daloRADIUSログ</b></h200> - daloRADIUS のログファイルをモニタリ
ングします<br/>
<h200><b>RADIUSログ</b></h200> - FreeRADIUS のログファイルをモニタリングします - /var/log/freeradius/radius.log または /usr/local/var/log/radius/radius.log の内容と同じです。
ログファイルが他の場所にある可能性もあります。その場合は、それに応じて設定を変更してください。	<br/>
<h200><b>システムログ</b></h200> - オペレーティングシステムのログファイルをモニタリングします - /var/log/syslog またはほとんどのプラットフォームで /var/log/message の内容と同じです
ログファイルが他の場所にある可能性もあります。その場合は、それに応じて設定を変更してください。	<br/>
<h200><b>起動ログ</b></h200> - オペレーティングシステムの起動ログファイルをモニタリングします - dmesg コマンドを実行した結果と同じです
";

$l['helpPage']['repmain'] = "
<b>概況</b><br/>
<h200><b>オンラインユーザ</b></h200> - データベースのアカウンティングテーブルからオンラインであるとされた全てのユーザを一覧表示します。
終了時間 (AcctStopTime) がセットされていないユーザであるかを確認することでオンライン判定されています。
注意点は、NASが何らかの理由でアカウンティング停止パケットを送ることに失敗したときに、これらのユーザが古いセッションを持っていることが起こるということです。<br/>
<h200><b>最終接続</b></h200> - ユーザログインの全ての Access-Accept と Access-Reject (成功と失敗) を一覧表示します<br/> 
これらはデータベースの postauth テーブルから引かれます。これらを実際にログ出力させるためには、postauth テーブルが FreeRADIUS の設定ファイルで定義されていなければなりません。<br/>
<h200><b>トップユーザ</b></h200> - 上位N位までのユーザについて、帯域使用状況とセッション利用時間を一覧表示します<br/><br/>
<b>レポートページの下位カテゴリ</b><br/>
<h200><b>ログ</b></h200> - daloRADIUSログファイル、FreeRADIUSログファイル、システムログファイル、起動ログファイルの内容を取得します<br/>
<h200><b>ステータス</b></h200> - サーバステータスとRADIUS 構成のステータスの情報を表示します";


$l['helpPage']['repstatradius'] = "サーバ概要: CPU使用、プロセス、稼働時間、メモリ使用、などを表示します";

$l['helpPage']['repstatserver'] = "FreeRADIUS デーモンと MySQL データベースサーバの概要を表示します";

$l['helpPage']['repstatus'] = "<b>状態</b><br/>
<h200><b>サーバ状態</b></h200> - サーバ概要: CPU使用、プロセス、稼働時間、メモリ使用、などを表示します<br/>
<h200><b>RADIUS 状態</b></h200> - FreeRADIUS デーモンと MySQL データベースサーバの概要を表示します";

$l['helpPage']['reptopusers'] = "以下のリストはセッション時間と帯域を最も多く消費しているトップユーザです。ユーザのカテゴリを一覧表示します。並べ替え：";

$l['helpPage']['repusername'] = "見つかったユーザのレコード:";

$l['helpPage']['reponline'] = "
以下の表はユーザシステムに接続しているユーザの一覧を表示します。
ユーザが接続を断っても、NASがRADIUSサーバに対してアカウンティング停止パケットを送らないまたは送れなかったときに、古いセッションが残ることが起こりえます。
";

$l['helpPage']['mnglistall'] = "データベースのユーザを一覧を表示します";

$l['helpPage']['mngsearch'] = "ユーザの検索: ";

$l['helpPage']['mngnew'] = "データベースに登録する新しいユーザの詳細を入力できます<br/>";

$l['helpPage']['mngedit'] = "以下のユーザの詳細を編集します<br/>";

$l['helpPage']['mngdel'] = "データベースからユーザエントリを削除するには、アカウントのユーザ名を指定しなければなりません<br/>";

$l['helpPage']['mngbatch'] = "データベースに登録する新しいユーザの詳細を入力できます。<br/>
これらの設定はあなたが作成する全てのユーザに適用されることに注意してください<br/>";

$l['helpPage']['mngnewquick'] = "以下の ユーザ/カード はプリペイド方式です。<br/>
タイムクレジットで指定される時間の長さは、RADIUSの Session-Timeout と Max-All-Session 属性に使われます。";

// accounting section

$l['helpPage']['acctactive'] = "
Expiration属性またはMax-All-Session属性を持つユーザに関して、データベースのアクティブユーザと期限切れユーザを追跡するために役立つ情報
<br/>
";

$l['helpPage']['acctall'] = "
データベースの全てのセッションの全てのアカウンティング情報を表示します
<br/>
";
$l['helpPage']['acctdate'] = "
与えられた2つの日付と指定されたユーザの全てのセッションの全てのアカウンティング情報を表示します
<br/>
";

$l['helpPage']['acctipaddress'] = "
特定のIPアドレスからの全てのセッションの全てのアカウンティング情報を表示します
<br/>
";

$l['helpPage']['acctplans'] = "";

$l['helpPage']['acctmain'] = "
<b>アカウンティング概要</b><br/>
<h200><b>ユーザアカウンティング</b></h200> - 
特定ユーザのデータベースの全てのセッションの全てのアカウンティング情報を表示します
<br/>
<h200><b>IPアカウンティング</b></h200> - 
特定IPアドレスからの全てのセッションの全てのアカウンティング情報を表示します
<br/>
<h200><b>NASアカウンティング</b></h200> - 
特定のNAS IPアドレスが使われた全てのセッションの全てのアカウンティング情報を表示します
<br/>
<h200><b>日付アカウンティング/b></h200> - 
与えられた2つの日付と指定されたユーザの全てのセッションの全てのアカウンティング情報を表示します
<br/>
<h200><b>全レコード</b></h200> - 
データベースの全てのセッションの全てのアカウンティング情報を表示します
<br/>
<h200><b>アクティブレコード</b></h200> - 
Expiration属性またはMax-All-Session属性を持つユーザに関して、データベースのアクティブユーザと期限切れユーザを追跡するために役立つ情報を表示します
<br/>

<br/>
<b>アカウンティングページの下位カテゴリ</b><br/>
<h200><b>カスタム</b></h200> - 
データベースで動作する非常に柔軟性のあるカスタムクエリを提供します。
<br/>
<h200><b>ホットスポット</b></h200> - 
異なる管理されたホットスポット、比較、その他の役立つ情報を表示します。
<br/>
";

$l['helpPage']['acctnasipaddress'] = "
特定のNAS IPアドレスが使われた全てのセッションの全てのアカウンティング情報を表示します
<br/>
";

$l['helpPage']['acctusername'] = "
特定ユーザのデータベースの全てのセッションの全てのアカウンティング情報を表示します
<br/>
";
// accounting hotspot section

$l['helpPage']['accthotspotaccounting'] = "
特定ホットスポットからの全てのセッションの全てのアカウンティング情報を表示します。
radacct テーブルで CalledStationId のフィールドが、ホットスポット管理データベースに登録されたホットスポットのMACアドレスエントリと一致したレコードだけをリストした結果を表示します。
<br/>
";

$l['helpPage']['accthotspotcompare'] = "
データベースに登録されている全てのアクティブなホットスポットの間で比較するための基本のアカウンティング情報を表示します。
アカウンティング情報の提供: <br/><br/>
ホットスポット名 - ホットスポットの名前<br/>
ユニークユーザ - このホットスポットのみを通してログインしたユーザ <br/>
総ヒット数 - このホットスポット (ユニークと非ユニーク) から行われたログインの合計<br/>
平均時間 - このホットスポットでユーザが費やした平均時間 <br/>
合計時間 - このホットスポットで全てのユーザが費やした合計時間 <br/>

<br/>
差異を比較したグラフを表示します
グラフ: <br/><br/>
ホットスポットごとのユニークユーザの分布<br/>
ホットスポットごとのヒット数の分布 <br/>
ホットスポットごとの利用時間の分布<br/>
<br/>
";

$l['helpPage']['accthotspot'] = "
<h200><b>ホットスポットアカウンティング</b></h200> - 
特定ホットスポットからの全てのセッションの全てのアカウンティング情報を表示します。
<br/>
<h200><b>ホットスポット比較</b></h200> - 
データベースに登録されている全てのアクティブなホットスポットの間の比較のための基礎的なアカウンティング情報を表示します。
差異を比較したグラフを表示します
<br/>
";
// accounting custom queries section

$l['helpPage']['acctcustom'] = "
<h200><b>カスタム</b></h200> - 
データベースで動作する非常に柔軟性のあるカスタムクエリを提供します。<br/>
左のサイドバーの設定を変更することでクエリを最大まで調節できます。<br/>
<br/>
<b> 期間 </b> - 開始日と終了日を設定します
<br/>
<b> 検索条件 </b> - 完全一致、部分一致で絞り込みたいデータベースのフィールドを設定します。
完全一致なら Equal を、部分一致 (正規表現のように) なら Contains を選択してください。
Contains を選択した場合、「*」文字のワイルドカードを入力するのではなく、あなたが入力した値に対して自動的に「*value*」(MySQL形式なら「%value%」) 形式で検索が行われます。
<br/>
<b> クエリに指定するアカウンティング・フィールド </b> - 検索結果一覧表にどのフィールドを表示するかを選択できます
<br/>
<b> 並べ替え </b> - 並び替えを行いたいフィールドと並び替え方式 (Ascending: 昇順、descending: 降順) を選択できます
<br/>
";

$l['helpPage']['acctcustomquery'] = "";

$l['helpPage']['acctmaintenance'] = "
<h200><b>古いセッションのクリア</b></h200> - 
NASがユーザセッションにアカウンティングSTOP レコードを送信することができなかったとき、
アカウンティングレコードに古いセッション開始が残り、ログインユーザレコードが虚偽の判定（偽陽性判定）
をするため、古いセッションがときどき存在します。
<br/>
<h200><b>アカウンティングレコードの削除</b></h200> - 
データベースのアカウントレコードの削除。上位の管理者以外のユーザがこのページにアクセスできるように許可することはふさわしくないかもしれません
<br/>
";
$l['helpPage']['acctmaintenancecleanup'] = "";
$l['helpPage']['acctmaintenancedelete'] = "";


$l['helpPage']['giseditmap'] = "
地図編集モード - このモードでは、ホットスポットの追加または削除が、それぞれ地図上の位置をクリックする、またはホットスポットをクリックすることで簡単にできます。<br/><br/>
<b> ホットスポットの追加 </b> - 地図上の何もない場所を単にクリックすると、ホットスポットの名前とMACアドレスを入力するように求められます。
後にこのホットスポットをアカウンティングテーブル上で識別するために使う、2つの極めて重要な詳細があります。常に正しい MACアドレスを入力してください!
<br/><br/>
<b> ホットスポットの削除</b> - ホットスポットのアイコンをクリックして、データベースからの削除を確認します。
<br/>
";

$l['helpPage']['gisviewmap'] = "
地図参照モード - このモードでは、GoogleMap サービスから提供される地図上のアイコンによって配置されたホットスポットを見ることができます。
<br/><br/>

<b> ホットスポットのクリック </b> - ホットスポットのより詳細な情報を見ることができます。
例えばホットスポットの問い合わせ情報や、統計的詳細など。
<br/>
";

$l['helpPage']['gismain'] = "
<b> 概要 </b>
GIS マッピングは Google Maps API を用いて世界中のホットスポットの位置を視覚的にマッピングします。 <br/>
管理ページでは新しいホットスポットのエントリをデータベースに追加することができます。データベースには Geolocation というフィールドがあり、これには Google Maps API がホットスポットの地図上の正確な位置を示すために使う数値が記録されます。<br/><br/>

<h200><b>2つの操作モードが用意されています:</b></h200>
ひとつは <b>地図参照</b> で、世界地図を「サーフィン」することができ、データベースにあるホットスポットの現在の位置を見ることができます。もうひとつは <b>地図編集</b> で、地図上で左クリックするだけでホットスポットを視覚的に作成したり、地図上に存在するホットスポットフラグを左クリックすることで既存のホットスポットを削除することができるモードです。<br/><br/>

その他の重要事項は、ネットワークのどちらのコンピュータも、あなたのサーバ上の daloRADIUS アプリケーションを設置したディレクトリへの完全なウェブアドレスを与えることで Google Maps API ページから得られるユニークな登録コードが必要であるということです。
一度Googleから登録コードを入手したら、「GoogleMaps API 登録コード」テキストボックスにそれを貼り付け、「Register code」 ボタンを押してください。
そうすれば、Google Maps サービスを利用できます。
<br/><br/>";
/* ********************************************************************************** */


$l['messages']['noCheckAttributesForUser'] = "このユーザに関連付けられたチェック属性はありません";
$l['messages']['noReplyAttributesForUser'] = "このユーザに関連付けられたリプライ属性はありません";

$l['messages']['noCheckAttributesForGroup'] = "このグループに関連付けられたチェック属性はありません";
$l['messages']['noReplyAttributesForGroup'] = "このグループに関連付けられたリプライ属性はありません";

$l['messages']['nogroupdefinedforuser'] = "このユーザに関連付けられたグループはありません";

$l['messages']['wouldyouliketocreategroup'] = "新規作成しますか?";
$l['messages']['missingratetype'] = "エラー: 削除するレートタイプがありません";
$l['messages']['missingtype'] = "エラー: タイプがありません";
$l['messages']['missingcardbank'] = "エラー: カード銀行がありません";
$l['messages']['missingrate'] = "エラー: レートがありません";
$l['messages']['success'] = "成功";

$l['messages']['gisedit1'] = "ようこそ。現在、編集モードです";
$l['messages']['gisedit2'] = "このマーカーをマップとデータベースから削除しますか?";
$l['messages']['gisedit3'] = "ホットスポット名を入力してください";
$l['messages']['gisedit4'] = "このマーカーをデータベースに追加しますか?";
$l['messages']['gisedit5'] = "ホットスポットの名前を入力してください";
$l['messages']['gisedit6'] = "ホットスポットのMACアドレスを入力してください";

$l['messages']['gismain1'] = "GoogleMaps API 登録コードのアップデートに成功しました。";
$l['messages']['gismain2'] = "エラー: ファイルが書き込みモードで開けません:";
$l['messages']['gismain3'] = "ファイルのアクセス権を確認してください。ファイルはウェブサーバの ユーザ/グループ が書き込み可能であるべきです";

$l['messages']['gisviewwelcome'] = "Enginxビジュアルマップにようこそ";

$l['messages']['loginerror'] = "<br/><br/>以下のいずれかです:<br/>
1. 不正な ユーザ名/パスワード<br/>
2. 管理者がすでにログインしています (一度に一インスタンスのみが許可されています) <br/>
3. データベースに 'administrator' ユーザが2つ以上存在します<br/>
";

$l['buttons']['savesettings'] = "設定保存";
$l['buttons']['apply'] = "適用";

$l['menu']['Home'] = "ホーム(<em>H</em>)</a>";
$l['menu']['Managment'] = "管理(<em>M</em>)</a>";
$l['menu']['Reports'] = "レポート(<em>R</em>)</a>";
$l['menu']['Accounting'] = "アカウンティング(<em>A</em>)</a>";
$l['menu']['Billing'] = "課金(<em>B</em>)</a>";
$l['menu']['Gis'] = "地理情報(<em>G</em>)</a>";
$l['menu']['Graphs'] = "グラフ(<em>G</em>)</a>";
$l['menu']['Config'] = "設定(<em>C</em>)</a>";
$l['menu']['Help'] = "ヘルプ(<em>H</em>)</a>";
?>
